/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;

public class ProjectBuildList
implements Iterable<ProjectSegment> {
    private final List<ProjectSegment> items;

    public ProjectBuildList(List<ProjectSegment> items) {
        this.items = Collections.unmodifiableList(items);
    }

    public ProjectBuildList getByTaskSegment(TaskSegment taskSegment) {
        ArrayList<ProjectSegment> currentSegment = new ArrayList<ProjectSegment>();
        for (ProjectSegment projectBuild : this.items) {
            if (taskSegment != projectBuild.getTaskSegment()) continue;
            currentSegment.add(projectBuild);
        }
        return new ProjectBuildList(currentSegment);
    }

    public Map<MavenProject, ProjectSegment> selectSegment(TaskSegment taskSegment) {
        HashMap<MavenProject, ProjectSegment> result2 = new HashMap<MavenProject, ProjectSegment>();
        for (ProjectSegment projectBuild : this.items) {
            if (taskSegment != projectBuild.getTaskSegment()) continue;
            result2.put(projectBuild.getProject(), projectBuild);
        }
        return result2;
    }

    public ProjectSegment findByMavenProject(MavenProject mavenProject) {
        for (ProjectSegment projectBuild : this.items) {
            if (!mavenProject.equals(projectBuild.getProject())) continue;
            return projectBuild;
        }
        return null;
    }

    @Override
    public Iterator<ProjectSegment> iterator() {
        return this.items.iterator();
    }

    public void closeAll() {
        for (ProjectSegment item : this.items) {
            MavenSession sessionForThisModule = item.getSession();
            sessionForThisModule.setCurrentProject(null);
        }
    }

    public int size() {
        return this.items.size();
    }

    public ProjectSegment get(int index2) {
        return this.items.get(index2);
    }

    public Set<String> getReactorProjectKeys() {
        HashSet<String> projectKeys = new HashSet<String>(this.items.size() * 2);
        for (ProjectSegment projectBuild : this.items) {
            MavenProject project = projectBuild.getProject();
            String key = ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Set<MavenProject> getProjects() {
        HashSet<MavenProject> projects = new HashSet<MavenProject>();
        for (ProjectSegment s : this.items) {
            projects.add(s.getProject());
        }
        return projects;
    }
}

