/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ResolutionErrorHandler.class)
public class DefaultResolutionErrorHandler
implements ResolutionErrorHandler {
    @Override
    public void throwErrors(ArtifactResolutionRequest request, ArtifactResolutionResult result2) throws ArtifactResolutionException {
        if (result2.hasMetadataResolutionExceptions()) {
            throw result2.getMetadataResolutionException(0);
        }
        if (result2.hasCircularDependencyExceptions()) {
            throw result2.getCircularDependencyException(0);
        }
        if (result2.hasVersionRangeViolations()) {
            throw result2.getVersionRangeViolation(0);
        }
        if (result2.hasErrorArtifactExceptions()) {
            throw result2.getErrorArtifactExceptions().get(0);
        }
        if (result2.hasMissingArtifacts()) {
            throw new MultipleArtifactsNotFoundException(request.getArtifact(), DefaultResolutionErrorHandler.toList(result2.getArtifacts()), result2.getMissingArtifacts(), request.getRemoteRepositories());
        }
        if (result2.hasExceptions()) {
            throw new ArtifactResolutionException("Unknown error during artifact resolution, " + request + ", " + result2.getExceptions(), request.getArtifact(), request.getRemoteRepositories());
        }
    }

    private static <T> List<T> toList(Collection<T> items) {
        return items != null ? new ArrayList<T>(items) : null;
    }
}

