/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass2) {
        LinkedHashMap<String, Enum> map2 = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass2.getEnumConstants()) {
            map2.put(e.name(), e);
        }
        return map2;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass2) {
        return new ArrayList<E>(Arrays.asList(enumClass2.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass2, String enumName) {
        return EnumUtils.getEnum(enumClass2, enumName) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> enumClass2, String enumName) {
        return EnumUtils.getEnumIgnoreCase(enumClass2, enumName) != null;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass2, String enumName) {
        if (enumName == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass2, enumName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass2, String enumName) {
        if (enumName == null || !enumClass2.isEnum()) {
            return null;
        }
        for (Enum each : (Enum[])enumClass2.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(enumName)) continue;
            return (E)each;
        }
        return null;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass2, Iterable<? extends E> values2) {
        EnumUtils.checkBitVectorable(enumClass2);
        Validate.notNull(values2);
        long total = 0L;
        for (Enum constant : values2) {
            Validate.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            total |= 1L << constant.ordinal();
        }
        return total;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass2, Iterable<? extends E> values2) {
        EnumUtils.asEnum(enumClass2);
        Validate.notNull(values2);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass2);
        for (Enum constant : values2) {
            Validate.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            condensed.add(constant);
        }
        long[] result2 = new long[(((Enum[])enumClass2.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value2 : condensed) {
            int n = value2.ordinal() / 64;
            result2[n] = result2[n] | 1L << value2.ordinal() % 64;
        }
        ArrayUtils.reverse(result2);
        return result2;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass2, E ... values2) {
        Validate.noNullElements(values2);
        return EnumUtils.generateBitVector(enumClass2, Arrays.asList(values2));
    }

    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass2, E ... values2) {
        EnumUtils.asEnum(enumClass2);
        Validate.noNullElements(values2);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass2);
        Collections.addAll(condensed, values2);
        long[] result2 = new long[(((Enum[])enumClass2.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value2 : condensed) {
            int n = value2.ordinal() / 64;
            result2[n] = result2[n] | 1L << value2.ordinal() % 64;
        }
        ArrayUtils.reverse(result2);
        return result2;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass2, long value2) {
        EnumUtils.checkBitVectorable(enumClass2).getEnumConstants();
        return EnumUtils.processBitVectors(enumClass2, value2);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass2, long ... values2) {
        EnumSet<Enum> results = EnumSet.noneOf(EnumUtils.asEnum(enumClass2));
        long[] lvalues = ArrayUtils.clone(Validate.notNull(values2));
        ArrayUtils.reverse(lvalues);
        for (Enum constant : (Enum[])enumClass2.getEnumConstants()) {
            int block = constant.ordinal() / 64;
            if (block >= lvalues.length || (lvalues[block] & 1L << constant.ordinal() % 64) == 0L) continue;
            results.add(constant);
        }
        return results;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass2) {
        Enum[] constants = (Enum[])EnumUtils.asEnum(enumClass2).getEnumConstants();
        Validate.isTrue(constants.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, constants.length, enumClass2.getSimpleName(), 64);
        return enumClass2;
    }

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass2) {
        Validate.notNull(enumClass2, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Validate.isTrue(enumClass2.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass2);
        return enumClass2;
    }
}

