/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMember;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaConstructor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import org.jetbrains.annotations.NotNull;

public final class ReflectJavaConstructor
extends ReflectJavaMember
implements JavaConstructor {
    @NotNull
    private final Constructor<?> member;

    public ReflectJavaConstructor(@NotNull Constructor<?> member2) {
        Intrinsics.checkNotNullParameter(member2, "member");
        this.member = member2;
    }

    @Override
    @NotNull
    public Constructor<?> getMember() {
        return this.member;
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        Annotation[][] annotationArray;
        Type[] typeArray;
        Type[] types2 = ((Constructor)this.getMember()).getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue(types2, "types");
        if (types2.length == 0) {
            return CollectionsKt.emptyList();
        }
        Class klass = ((Constructor)this.getMember()).getDeclaringClass();
        if (klass.getDeclaringClass() != null && !Modifier.isStatic(klass.getModifiers())) {
            Type[] typeArray2 = types2;
            int n = 1;
            int n2 = types2.length;
            typeArray = ArraysKt.copyOfRange(typeArray2, n, n2);
        } else {
            typeArray = types2;
        }
        Type[] realTypes = typeArray;
        Annotation[][] annotations2 = ((Constructor)this.getMember()).getParameterAnnotations();
        if (((Object[])annotations2).length < realTypes.length) {
            throw new IllegalStateException(Intrinsics.stringPlus("Illegal generic signature: ", this.getMember()));
        }
        if (((Object[])annotations2).length > realTypes.length) {
            Intrinsics.checkNotNullExpressionValue(annotations2, "annotations");
            Object[] objectArray = (Object[])annotations2;
            int n = ((Object[])annotations2).length - realTypes.length;
            int n3 = ((Object[])annotations2).length;
            annotationArray = (Annotation[][])ArraysKt.copyOfRange(objectArray, n, n3);
        } else {
            annotationArray = annotations2;
        }
        Annotation[][] realAnnotations = annotationArray;
        Intrinsics.checkNotNullExpressionValue(realTypes, "realTypes");
        Intrinsics.checkNotNullExpressionValue(realAnnotations, "realAnnotations");
        return this.getValueParameters(realTypes, realAnnotations, ((Constructor)this.getMember()).isVarArgs());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Constructor<T>>[] typeVariableArray = ((Constructor)this.getMember()).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, "member.typeParameters");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable2 = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReflectJavaTypeParameter reflectJavaTypeParameter = new ReflectJavaTypeParameter((TypeVariable<?>)p0);
            collection.add(reflectJavaTypeParameter);
        }
        return (List)destination$iv$iv;
    }
}

