/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Key;
import com.google.inject.internal.ConstructionContext;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.DependencyAndSource;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

final class InternalContext
implements AutoCloseable {
    private final InjectorImpl.InjectorOptions options;
    private final Map<Object, ConstructionContext<?>> constructionContexts = new IdentityHashMap();
    private Dependency<?> dependency;
    private Object[] dependencyStack = new Object[16];
    private int dependencyStackSize = 0;
    private int enterCount;
    private final Object[] toClear;

    InternalContext(InjectorImpl.InjectorOptions options, Object[] toClear) {
        this.options = options;
        this.toClear = toClear;
        this.enterCount = 1;
    }

    void enter() {
        ++this.enterCount;
    }

    @Override
    public void close() {
        int newCount;
        if ((newCount = --this.enterCount) < 0) {
            throw new IllegalStateException("Called close() too many times");
        }
        if (newCount == 0) {
            this.toClear[0] = null;
        }
    }

    InjectorImpl.InjectorOptions getInjectorOptions() {
        return this.options;
    }

    <T> ConstructionContext<T> getConstructionContext(Object key) {
        ConstructionContext<Object> constructionContext = this.constructionContexts.get(key);
        if (constructionContext == null) {
            constructionContext = new ConstructionContext();
            this.constructionContexts.put(key, constructionContext);
        }
        return constructionContext;
    }

    Dependency<?> getDependency() {
        return this.dependency;
    }

    Dependency<?> pushDependency(Dependency<?> dependency, Object source) {
        Dependency<?> previous = this.dependency;
        this.dependency = dependency;
        this.doPushState(dependency, source);
        return previous;
    }

    void popStateAndSetDependency(Dependency<?> newDependency) {
        this.popState();
        this.dependency = newDependency;
    }

    void pushState(Key<?> key, Object source) {
        this.doPushState(key, source);
    }

    private void doPushState(Object dependencyOrKey, Object source) {
        Object[] localStack = this.dependencyStack;
        int localSize = this.dependencyStackSize;
        if (localStack.length < localSize + 2) {
            localStack = this.dependencyStack = Arrays.copyOf(localStack, localStack.length * 3 / 2 + 2);
        }
        localStack[localSize++] = dependencyOrKey;
        localStack[localSize++] = source;
        this.dependencyStackSize = localSize;
    }

    void popState() {
        this.dependencyStackSize -= 2;
    }

    List<DependencyAndSource> getDependencyChain() {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (int i = 0; i < this.dependencyStackSize; i += 2) {
            Object evenEntry = this.dependencyStack[i];
            Dependency dependency = evenEntry instanceof Key ? Dependency.get((Key)evenEntry) : (Dependency)evenEntry;
            builder2.add(new DependencyAndSource(dependency, this.dependencyStack[i + 1]));
        }
        return builder2.build();
    }
}

