/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.model.Active;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.Signing;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.model.internal.release.CodebergReleaser;
import org.jreleaser.model.internal.release.GenericGitReleaser;
import org.jreleaser.model.internal.release.GiteaReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class BaseReleaserValidator {
    private static final String DEFAULT_CHANGELOG_TPL = "src/jreleaser/templates/changelog.tpl";
    private static final String DEFAULT_APPEND_CHANGELOG_TPL = "src/jreleaser/templates/append-changelog.tpl";

    private BaseReleaserValidator() {
    }

    public static void validateGitService(JReleaserContext context, JReleaserContext.Mode mode, BaseReleaser<?, ?> service, Errors errors) {
        GithubReleaser gh;
        JReleaserModel model = context.getModel();
        Project project = model.getProject();
        if (!service.isEnabledSet()) {
            service.setEnabled(true);
        }
        if (!service.isEnabled()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!mode.validateStandalone() && StringUtils.isBlank((String)service.getOwner()) && !(service instanceof GenericGitReleaser)) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{service.getServiceName() + ".owner"}));
        }
        if (StringUtils.isBlank((String)service.getName())) {
            service.setName(project.getName());
        }
        String baseKey = "release." + service.getServiceName() + ".";
        service.setUsername(Validator.checkProperty(context, service.getServiceName().toUpperCase(Locale.ENGLISH) + "_USERNAME", baseKey + "username", service.getUsername(), service.getOwner()));
        service.setToken(Validator.checkProperty(context, service.getServiceName().toUpperCase(Locale.ENGLISH) + "_TOKEN", baseKey + "token", service.getToken(), !mode.validateStandalone() ? errors : new Errors()));
        service.setTagName(Validator.checkProperty(context, "TAG_NAME", baseKey + "tagName", service.getTagName(), "v{{projectVersion}}"));
        service.setPreviousTagName(Validator.checkProperty(context, "PREVIOUS_TAG_NAME", baseKey + "previousTagName", service.getPreviousTagName(), ""));
        if (service.isReleaseSupported()) {
            service.setReleaseName(Validator.checkProperty(context, "RELEASE_NAME", baseKey + "releaseName", service.getReleaseName(), "Release {{tagName}}"));
        }
        service.setBranch(Validator.checkProperty(context, "BRANCH", baseKey + "branch", service.getBranch(), "main"));
        service.setBranchPush(Validator.checkProperty(context, "BRANCH_PUSH", baseKey + "branch.push", service.getBranchPush(), service.getBranch()));
        if (!service.isOverwriteSet()) {
            service.setOverwrite(Validator.checkProperty(context, "OVERWRITE", baseKey + "overwrite", null, false));
        }
        if (service.isReleaseSupported()) {
            if (!service.getUpdate().isEnabledSet()) {
                service.getUpdate().setEnabled(Validator.checkProperty(context, "UPDATE", baseKey + "update", null, false));
            }
            if (service.getUpdate().isEnabled() && service.getUpdate().getSections().isEmpty()) {
                service.getUpdate().getSections().add(UpdateSection.ASSETS);
            }
        }
        if (!service.isSkipTagSet()) {
            service.setSkipTag(Validator.checkProperty(context, "SKIP_TAG", baseKey + "skipTag", null, false));
        }
        if (!service.isSkipReleaseSet()) {
            service.setSkipRelease(Validator.checkProperty(context, "SKIP_RELEASE", baseKey + "skipRelease", null, false));
        }
        if (StringUtils.isBlank((String)service.getTagName())) {
            service.setTagName("v" + project.getVersion());
        }
        if (service.isReleaseSupported()) {
            if (StringUtils.isBlank((String)service.getReleaseName())) {
                service.setReleaseName("Release {{ tagName }}");
            }
            service.getMilestone().setName(Validator.checkProperty(context, "MILESTONE_NAME", baseKey + "milestone.name", service.getMilestone().getName(), "{{tagName}}"));
            BaseReleaser.Issues issues = service.getIssues();
            if (StringUtils.isBlank((String)issues.getComment())) {
                issues.setComment(RB.$((String)"default.release.issue.message", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((String)issues.getLabel().getName())) {
                issues.getLabel().setName(RB.$((String)"default.release.issue.label.text", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((String)issues.getLabel().getColor())) {
                issues.getLabel().setColor(RB.$((String)"default.release.issue.label.color", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((String)issues.getLabel().getDescription())) {
                issues.getLabel().setDescription(RB.$((String)"default.release.issue.label.desc", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isBlank((String)service.getCommitAuthor().getName())) {
            service.getCommitAuthor().setName("jreleaserbot");
        }
        if (StringUtils.isBlank((String)service.getCommitAuthor().getEmail())) {
            service.getCommitAuthor().setEmail("jreleaser@kordamp.org");
        }
        Validator.validateTimeout(service);
        service.getResolvedTagName(context.getModel());
        service.getResolvedBranchPush(context.getModel());
        if (service.isReleaseSupported()) {
            service.getResolvedReleaseName(context.getModel());
            service.getMilestone().getResolvedName(service.props(context.getModel()));
        }
        if (project.isSnapshot()) {
            BaseReleaser g;
            boolean generate = false;
            if (service instanceof GithubReleaser) {
                gh = (GithubReleaser)service;
                generate = gh.getReleaseNotes().isEnabled();
                if (!gh.isDraftSet()) {
                    gh.setDraft(false);
                }
            }
            if (service instanceof GiteaReleaser && !((GiteaReleaser)(g = (GiteaReleaser)service)).isDraftSet()) {
                ((GiteaReleaser)g).setDraft(false);
            }
            if (service instanceof CodebergReleaser && !((CodebergReleaser)(g = (CodebergReleaser)service)).isDraftSet()) {
                ((CodebergReleaser)g).setDraft(false);
            }
            if (!generate) {
                service.getChangelog().setEnabled(true);
                service.getChangelog().setSort(Changelog.Sort.DESC);
            }
            if (service.isReleaseSupported()) {
                service.setOverwrite(true);
            }
            service.getIssues().setEnabled(false);
        }
        if (!service.getChangelog().isEnabledSet()) {
            boolean generate = false;
            if (service instanceof GithubReleaser) {
                gh = (GithubReleaser)service;
                generate = gh.getReleaseNotes().isEnabled();
            }
            if (!generate) {
                service.getChangelog().setEnabled(true);
            }
        }
        if (!mode.validateStandalone()) {
            BaseReleaserValidator.validateChangelog(context, service, errors);
        }
        if (mode.validateConfig()) {
            if (service.isSign() && model.getSigning().getMode() == Signing.Mode.COSIGN) {
                service.setSign(false);
                errors.warning(RB.$((String)"validation_git_signing_cosign", (Object[])new Object[]{service.getServiceName()}));
                return;
            }
            if (service.isSign() && !model.getSigning().isEnabled()) {
                if (context.isDryrun()) {
                    service.setSign(false);
                } else {
                    errors.configuration(RB.$((String)"validation_git_signing", (Object[])new Object[]{service.getServiceName()}));
                }
            }
        }
    }

    private static void validateChangelog(JReleaserContext context, BaseReleaser<?, ?> service, Errors errors) {
        GithubReleaser gh;
        boolean generate;
        Changelog changelog = service.getChangelog();
        if (StringUtils.isNotBlank((String)changelog.getExternal())) {
            changelog.setEnabled(true);
            changelog.setFormatted(Active.NEVER);
        }
        if (!changelog.isEnabledSet() && changelog.isSet()) {
            changelog.setEnabled(true);
        }
        if (service instanceof GithubReleaser && (generate = (gh = (GithubReleaser)service).getReleaseNotes().isEnabled()) && changelog.isEnabled()) {
            errors.configuration(RB.$((String)"validation_github_releasenotes_changelog", (Object[])new Object[0]));
            return;
        }
        if (!changelog.resolveFormatted(context.getModel().getProject())) {
            return;
        }
        if (null == changelog.getSort()) {
            changelog.setSort(Changelog.Sort.DESC);
        }
        if (StringUtils.isBlank((String)changelog.getCategoryTitleFormat())) {
            changelog.setCategoryTitleFormat("## {{categoryTitle}}");
        }
        if (StringUtils.isBlank((String)changelog.getContributorsTitleFormat())) {
            changelog.setContributorsTitleFormat("## Contributors");
        }
        if (StringUtils.isBlank((String)changelog.getContent()) && StringUtils.isBlank((String)changelog.getContentTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_CHANGELOG_TPL), new LinkOption[0])) {
                changelog.setContentTemplate(DEFAULT_CHANGELOG_TPL);
            } else {
                changelog.setContent(System.lineSeparator() + "## Changelog" + System.lineSeparator() + System.lineSeparator() + "{{changelogChanges}}" + System.lineSeparator() + "    {{changelogContributors}}");
            }
        }
        if (StringUtils.isNotBlank((String)changelog.getContentTemplate()) && !Files.exists(context.getBasedir().resolve(changelog.getContentTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"changelog.contentTemplate", changelog.getContentTemplate()}));
        }
        if (StringUtils.isNotBlank((String)changelog.getPreset())) {
            BaseReleaserValidator.loadPreset(context, changelog, errors);
        }
        if (StringUtils.isBlank((String)changelog.getFormat())) {
            changelog.setFormat("- {{commitShortHash}} {{commitTitle}} ({{commitAuthor}})");
        }
        if (changelog.getCategories().isEmpty()) {
            changelog.getCategories().add(Changelog.Category.of("feature", RB.$((String)"default.category.feature", (Object[])new Object[0]), "", "feature", "enhancement"));
            changelog.getCategories().add(Changelog.Category.of("fix", RB.$((String)"default.category.bug.fix", (Object[])new Object[0]), "", "bug", "fix"));
        } else {
            int i = 0;
            for (Changelog.Category category : changelog.getCategories()) {
                if (StringUtils.isBlank((String)category.getTitle())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.categories[" + i + "].title"}));
                }
                if (category.getLabels().isEmpty()) {
                    errors.configuration(RB.$((String)"validation_are_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.categories[" + i + "].labels"}));
                }
                ++i;
            }
            Map<String, List<Changelog.Category>> byTitle = changelog.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getTitle));
            byTitle.forEach((title, categories) -> {
                if (categories.size() > 1) {
                    errors.configuration(RB.$((String)"validationgetChangelog_multiple_categories", (Object[])new Object[]{service.getServiceName(), title}));
                }
            });
        }
        if (!changelog.getLabelers().isEmpty()) {
            int i = 0;
            for (Changelog.Labeler labeler : changelog.getLabelers()) {
                if (StringUtils.isBlank((String)labeler.getLabel())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.labelers[" + i + "].label"}));
                }
                if (StringUtils.isBlank((String)labeler.getTitle()) && StringUtils.isBlank((String)labeler.getBody())) {
                    errors.configuration(RB.$((String)"validation_git_required", (Object[])new Object[]{service.getServiceName() + ".changelog.labelers[" + i + "] title", "body"}));
                }
                ++i;
            }
        }
        if (!changelog.getReplacers().isEmpty()) {
            int i = 0;
            for (Changelog.Replacer replacer : changelog.getReplacers()) {
                if (StringUtils.isBlank((String)replacer.getSearch())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.replacers[" + i + "].search"}));
                }
                if (null == replacer.getReplace()) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.replacers[" + i + "].replace"}));
                }
                ++i;
            }
        }
        if (!changelog.getContributors().isEnabledSet()) {
            changelog.getContributors().setEnabled(true);
        }
        if (!changelog.getAppend().isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((String)changelog.getAppend().getTitle())) {
            changelog.getAppend().setTitle("## [{{tagName}}]");
        }
        if (StringUtils.isBlank((String)changelog.getAppend().getTarget())) {
            changelog.getAppend().setTarget("CHANGELOG.md");
        }
        if (StringUtils.isBlank((String)changelog.getAppend().getTarget())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.append.target"}));
        }
        if (StringUtils.isBlank((String)changelog.getAppend().getContent()) && StringUtils.isBlank((String)changelog.getAppend().getContentTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_APPEND_CHANGELOG_TPL), new LinkOption[0])) {
                changelog.getAppend().setContentTemplate(DEFAULT_APPEND_CHANGELOG_TPL);
            } else {
                changelog.getAppend().setContent(System.lineSeparator() + "{{changelogTitle}}" + System.lineSeparator() + System.lineSeparator() + "{{changelogContent}}");
            }
        }
        if (StringUtils.isNotBlank((String)changelog.getAppend().getContentTemplate()) && !Files.exists(context.getBasedir().resolve(changelog.getAppend().getContentTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"changelog.append.contentTemplate", changelog.getAppend().getContentTemplate()}));
        }
    }

    private static void loadPreset(JReleaserContext context, Changelog changelog, Errors errors) {
        try {
            String preset = changelog.getPreset().toLowerCase(Locale.ENGLISH).trim();
            String presetFileName = "META-INF/jreleaser/changelog/preset-" + preset + ".yml";
            InputStream inputStream = BaseReleaserValidator.class.getClassLoader().getResourceAsStream(presetFileName);
            if (null != inputStream) {
                Changelog loaded = JReleaserConfigLoader.load(Changelog.class, presetFileName, inputStream);
                if (StringUtils.isBlank((String)changelog.getFormat())) {
                    changelog.setFormat(loaded.getFormat());
                }
                TreeSet<Changelog.Labeler> labelersCopy = new TreeSet<Changelog.Labeler>(Changelog.Labeler.ORDER_COMPARATOR);
                labelersCopy.addAll(changelog.getLabelers());
                labelersCopy.addAll(loaded.getLabelers());
                changelog.setLabelers(labelersCopy);
                ArrayList<Changelog.Replacer> replacersCopy = new ArrayList<Changelog.Replacer>(changelog.getReplacers());
                replacersCopy.addAll(loaded.getReplacers());
                changelog.setReplacers(replacersCopy);
                Map<String, List<Changelog.Category>> categoriesByKey = changelog.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getKey));
                Map<String, List<Changelog.Category>> loadedCategoriesByKey = loaded.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getKey));
                categoriesByKey.forEach((categoryKey, categories) -> {
                    if (loadedCategoriesByKey.containsKey(categoryKey)) {
                        Changelog.Category loadedCategory = (Changelog.Category)((List)loadedCategoriesByKey.remove(categoryKey)).get(0);
                        Changelog.Category category = (Changelog.Category)categories.get(0);
                        category.addLabels(loadedCategory.getLabels());
                    }
                });
                loadedCategoriesByKey.values().forEach(list -> changelog.getCategories().add((Changelog.Category)list.get(0)));
                changelog.setCategories(Changelog.Category.sort(changelog.getCategories()));
                changelog.getHide().addCategories(loaded.getHide().getCategories());
                changelog.getHide().addContributors(loaded.getHide().getContributors());
            } else {
                context.getLogger().warn(RB.$((String)"changelog.preset.not.found", (Object[])new Object[0]), new Object[]{preset});
            }
        }
        catch (IOException e) {
            context.getLogger().warn(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
    }
}

