/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AppImagePackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class AppImagePackagerValidator {
    private AppImagePackagerValidator() {
    }

    public static void validateAppImage(JReleaserContext context, Distribution distribution, AppImagePackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}.appImage", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        AppImagePackager parentPackager = model.getPackagers().getAppImage();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getComponentId()) && StringUtils.isNotBlank((String)parentPackager.getComponentId())) {
            packager.setComponentId(parentPackager.getComponentId());
        }
        if (StringUtils.isBlank((String)packager.getComponentId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.componentId"}));
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(parentPackager.getCategories());
        }
        if (packager.getCategories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.categories"}));
        }
        if (!packager.isRequiresTerminalSet() && parentPackager.isRequiresTerminalSet()) {
            packager.setRequiresTerminal(parentPackager.isRequiresTerminal());
        }
        if (distribution.getStereotype() == Stereotype.CLI) {
            packager.setRequiresTerminal(true);
        }
        if (StringUtils.isBlank((String)packager.getDeveloperName())) {
            packager.setDeveloperName(parentPackager.getDeveloperName());
        }
        if (packager.getScreenshots().isEmpty()) {
            packager.setScreenshots(parentPackager.getScreenshots());
        }
        if (packager.getScreenshots().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.screenshots"}));
        }
        Validator.validateScreenshots(packager.getScreenshots(), errors, "distribution." + distribution.getName() + ".appImage");
        packager.getScreenshots().removeIf(screenshot -> StringUtils.isTrue((Object)screenshot.getExtraProperties().get("skipAppImage")));
        if (packager.getScreenshots().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.screenshots"}));
        }
        if (packager.getIcons().isEmpty()) {
            packager.setIcons(parentPackager.getIcons());
        }
        if (packager.getIcons().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.icons"}));
        }
        Validator.validateIcons(packager.getIcons(), errors, "distribution." + distribution.getName() + ".appImage");
        packager.getIcons().removeIf(icon -> StringUtils.isTrue((Object)icon.getExtraProperties().get("skipAppImage")));
        if (packager.getIcons().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.icons"}));
        }
        for (int i = 0; i < packager.getIcons().size(); ++i) {
            Icon icon2 = packager.getIcons().get(i);
            if (null == icon2.getWidth() || icon2.getWidth().equals(icon2.getHeight())) continue;
            errors.configuration(RB.$((String)"validation_must_be_equal", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.icons[" + i + "].width", icon2.getWidth(), "distribution." + distribution.getName() + ".appImage.icons[" + i + "].height", icon2.getHeight()}));
        }
        if (packager.getIcons().size() == 1) {
            packager.getIcons().get(0).setPrimary(true);
        }
        if (packager.getIcons().stream().mapToInt(s -> s.isPrimary() ? 1 : 0).sum() == 0) {
            errors.configuration(RB.$((String)"validation_no_primary_icon", (Object[])new Object[]{"distribution." + distribution.getName() + ".appImage.icons"}));
        }
        if (StringUtils.isBlank((String)packager.getRepository().getName())) {
            packager.getRepository().setName(distribution.getName() + "-appimage");
        }
        packager.getRepository().setTapName(distribution.getName() + "-appimage");
        if (distribution.getStereotype() != Stereotype.CLI && distribution.getStereotype() != Stereotype.DESKTOP) {
            errors.configuration(RB.$((String)"validation_stereotype_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".stereotype", distribution.getStereotype(), CollectionUtils.listOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP})}));
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        AppImagePackager.AppImageRepository repository = packager.getRepository();
        Validator.validateRepository(context, distribution, repository, parentPackager.getRepository(), "appImage.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
    }
}

