/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssemblerValidator {
    private NativeImageAssemblerValidator() {
    }

    public static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, NativeImageAssembler> nativeImage = context.getModel().getAssemble().getNativeImage();
        if (!nativeImage.isEmpty()) {
            context.getLogger().debug("assemble.nativeImage");
        }
        for (Map.Entry<String, NativeImageAssembler> e : nativeImage.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            NativeImageAssemblerValidator.validateNativeImage(context, mode, e.getValue(), errors);
        }
    }

    private static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, NativeImageAssembler assembler, Errors errors) {
        context.getLogger().debug("assemble.nativeImage.{}", new Object[]{assembler.getName()});
        Validator.resolveActivatable(context, (Activatable)assembler, CollectionUtils.listOf((Object[])new String[]{"assemble.native.image." + assembler.getName(), "assemble.native.image"}), "NEVER");
        if (!assembler.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (null == assembler.getStereotype()) {
            assembler.setStereotype(context.getModel().getProject().getStereotype());
        }
        if (StringUtils.isBlank((String)assembler.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"nativeImage.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            assembler.disable();
            return;
        }
        if (null == assembler.getMainJar()) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"nativeImage." + assembler.getName() + ".mainJar"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            return;
        }
        context.getLogger().debug("assemble.nativeImage.{}.java", new Object[]{assembler.getName()});
        AssemblersValidator.validateJava(context, assembler, errors);
        assembler.setPlatform(assembler.getPlatform().mergeValues(context.getModel().getPlatform()));
        if (StringUtils.isBlank((String)assembler.getExecutable())) {
            assembler.setExecutable(assembler.getName());
        }
        if (StringUtils.isBlank((String)assembler.getImageName())) {
            assembler.setImageName(assembler.getExecutable() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        int i = 0;
        for (Artifact graalJdk : assembler.getGraalJdks()) {
            NativeImageAssemblerValidator.validateJdk(context, mode, assembler, graalJdk, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = assembler.getGraalJdks().stream().collect(Collectors.groupingBy(jdk -> StringUtils.isBlank((String)jdk.getPlatform()) ? "<nil>" : jdk.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_nativeimage_jdk_platform", (Object[])new Object[]{assembler.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_nativeimage_jdk_multiple_platforms", (Object[])new Object[]{assembler.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)assembler.getGraal().getPath())) {
            String currentPlatform = PlatformUtils.getCurrentFull();
            String javaHome = System.getProperty("java.home");
            if (assembler.getGraalJdks().isEmpty()) {
                if (StringUtils.isBlank((String)javaHome)) {
                    errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                    return;
                }
                assembler.getGraal().setPath(javaHome);
                assembler.getGraal().setPlatform(currentPlatform);
            } else {
                Optional<Artifact> jdk2 = assembler.getGraalJdks().stream().filter(j -> PlatformUtils.isCompatible((String)currentPlatform, (String)j.getPlatform())).findFirst();
                if (jdk2.isPresent()) {
                    assembler.setGraal(jdk2.get());
                } else {
                    if (StringUtils.isBlank((String)javaHome)) {
                        errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                        return;
                    }
                    assembler.getGraal().setPath(javaHome);
                    assembler.getGraal().setPlatform(currentPlatform);
                }
            }
        }
        if (null == assembler.getArchiveFormat()) {
            assembler.setArchiveFormat(Archive.Format.ZIP);
        }
        if (null == assembler.getOptions().getTimestamp()) {
            assembler.getOptions().setTimestamp(context.getModel().resolveArchiveTimestamp());
        }
        AssemblersValidator.validateJavaAssembler(context, mode, assembler, errors, true);
        assembler.getComponents().remove("native-image");
        NativeImageAssembler.Upx upx = assembler.getUpx();
        Validator.resolveActivatable(context, (Activatable)upx, CollectionUtils.listOf((Object[])new String[]{"assemble.native.image." + assembler.getName() + ".upx", "assemble.native.image.upx"}), "NEVER");
        if (!upx.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)upx.getVersion())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"nativeImage." + assembler.getName() + ".upx.version"}));
        }
    }

    private static void validateJdk(JReleaserContext context, JReleaserContext.Mode mode, NativeImageAssembler nativeImage, Artifact jdk, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == jdk) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".graalJdk[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)jdk.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".graalJdk[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)jdk.getPlatform()) && !PlatformUtils.isSupported((String)jdk.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_nativeimage_platform", (Object[])new Object[]{nativeImage.getName(), index, jdk.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }
}

