/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.CollectionUtils;

public final class FileSet
extends AbstractModelObject<FileSet>
implements Domain,
ExtraProperties {
    private static final String GLOB_PREFIX = "glob:";
    private static final long serialVersionUID = 1108903420380266057L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<String> includes = new LinkedHashSet<String>();
    private final Set<String> excludes = new LinkedHashSet<String>();
    private String input;
    private String output;
    private Boolean failOnMissingInput;
    @JsonIgnore
    private final org.jreleaser.model.api.common.FileSet immutable = new org.jreleaser.model.api.common.FileSet(){
        private static final long serialVersionUID = 1386323645145691467L;

        public Set<String> getIncludes() {
            return Collections.unmodifiableSet(FileSet.this.includes);
        }

        public Set<String> getExcludes() {
            return Collections.unmodifiableSet(FileSet.this.excludes);
        }

        public String getInput() {
            return FileSet.this.input;
        }

        public String getOutput() {
            return FileSet.this.output;
        }

        public boolean isFailOnMissingInput() {
            return FileSet.this.isFailOnMissingInput();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FileSet.this.asMap(full));
        }

        public String getPrefix() {
            return FileSet.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FileSet.this.extraProperties);
        }
    };

    public org.jreleaser.model.api.common.FileSet asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FileSet source) {
        this.input = this.merge(this.input, source.input);
        this.output = this.merge(this.output, source.output);
        this.failOnMissingInput = this.merge(this.failOnMissingInput, source.failOnMissingInput);
        this.setIncludes(this.merge(this.includes, source.includes));
        this.setExcludes(this.merge(this.excludes, source.excludes));
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    @Override
    public String prefix() {
        return "artifact";
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isFailOnMissingInput() {
        return null == this.failOnMissingInput || this.failOnMissingInput != false;
    }

    public void setFailOnMissingInput(Boolean failOnMissingInput) {
        this.failOnMissingInput = failOnMissingInput;
    }

    public boolean isFailOnMissingInputSet() {
        return null != this.failOnMissingInput;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("input", this.input);
        props.put("output", this.output);
        props.put("includes", this.includes);
        props.put("excludes", this.excludes);
        props.put("failOnMissingInput", this.failOnMissingInput);
        props.put("extraProperties", this.getExtraProperties());
        return props;
    }

    public String getResolvedInput(JReleaserContext context) {
        return Artifacts.resolveForFileSet(this.input, context, this);
    }

    public String getResolvedOutput(JReleaserContext context) {
        return Artifacts.resolveForFileSet(this.output, context, this);
    }

    public Set<String> getResolvedIncludes(JReleaserContext context) {
        return this.includes.stream().map(s -> Artifacts.resolveForFileSet(s, context, this)).collect(Collectors.toSet());
    }

    public Set<String> getResolvedExcludes(JReleaserContext context) {
        return this.excludes.stream().map(s -> Artifacts.resolveForFileSet(s, context, this)).collect(Collectors.toSet());
    }

    public Set<Path> getResolvedPaths(JReleaserContext context) throws IOException {
        Path basedir = context.getBasedir().resolve(this.getResolvedInput(context)).normalize().toAbsolutePath();
        Set resolvedIncludes = this.getResolvedIncludes(context);
        if (resolvedIncludes.isEmpty()) {
            resolvedIncludes = CollectionUtils.setOf((Object[])new String[]{"**/*"});
        }
        resolvedIncludes = resolvedIncludes.stream().map(s -> GLOB_PREFIX + s).collect(Collectors.toSet());
        Set<String> resolvedExcludes = this.getResolvedExcludes(context);
        resolvedExcludes = resolvedExcludes.stream().map(s -> GLOB_PREFIX + s).collect(Collectors.toSet());
        if (!Files.exists(basedir, new LinkOption[0])) {
            if (this.isFailOnMissingInput()) {
                throw new IOException(RB.$((String)"ERROR_artifacts_glob_missing_input", (Object[])new Object[]{context.getBasedir().relativize(basedir)}));
            }
            context.getLogger().debug(RB.$((String)"ERROR_artifacts_glob_missing_input", (Object[])new Object[]{context.getBasedir().relativize(basedir)}));
            return new LinkedHashSet<Path>();
        }
        GlobResolver resolver = new GlobResolver(context.getLogger(), basedir, resolvedIncludes, resolvedExcludes);
        Files.walkFileTree(basedir, resolver);
        if (resolver.failed) {
            throw new IOException(RB.$((String)"ERROR_artifacts_glob_resolution", (Object[])new Object[0]));
        }
        return resolver.paths;
    }

    private static final class ExtPathMatcher {
        private final PathMatcher matcher;
        private final boolean recursive;

        private ExtPathMatcher(PathMatcher matcher, boolean recursive) {
            this.matcher = matcher;
            this.recursive = recursive;
        }
    }

    private static final class GlobResolver
    extends SimpleFileVisitor<Path> {
        private final JReleaserLogger logger;
        private final Set<ExtPathMatcher> includes = new LinkedHashSet<ExtPathMatcher>();
        private final Set<ExtPathMatcher> excludes = new LinkedHashSet<ExtPathMatcher>();
        private final Path basedir;
        private final Set<Path> paths = new LinkedHashSet<Path>();
        private boolean failed;

        private GlobResolver(JReleaserLogger logger, Path basedir, Set<String> includes, Set<String> excludes) {
            this.logger = logger;
            this.basedir = basedir;
            FileSystem fileSystem = FileSystems.getDefault();
            for (String s : includes) {
                this.includes.add(new ExtPathMatcher(fileSystem.getPathMatcher(s), s.contains("**")));
            }
            for (String s : excludes) {
                this.excludes.add(new ExtPathMatcher(fileSystem.getPathMatcher(s), s.contains("**")));
            }
        }

        private void match(Path path) {
            if (this.includes.stream().anyMatch(matcher -> this.matches(path, (ExtPathMatcher)matcher)) && this.excludes.stream().noneMatch(matcher -> this.matches(path, (ExtPathMatcher)matcher))) {
                this.paths.add(this.basedir.relativize(path));
            }
        }

        private boolean matches(Path path, ExtPathMatcher matcher) {
            if (matcher.recursive) {
                return matcher.matcher.matches(path);
            }
            return this.basedir.normalize().equals(path.normalize().getParent()) && matcher.matcher.matches(path.getFileName());
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.basedir.normalize().equals(dir.normalize())) {
                return FileVisitResult.CONTINUE;
            }
            if (this.includes.stream().anyMatch(matcher -> ((ExtPathMatcher)matcher).recursive)) {
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            this.logger.error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[0]), new Object[]{this.basedir.toAbsolutePath().relativize(file.toAbsolutePath()), e});
            return FileVisitResult.CONTINUE;
        }
    }
}

