/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.files;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.files.Files;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public final class FilesValidator {
    private FilesValidator() {
    }

    public static void validateFiles(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("files");
        Files files = context.getModel().getFiles();
        Validator.resolveActivatable(context, (Activatable)files, "files", "ALWAYS");
        if (!files.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        files.getArtifacts().forEach(artifact -> {
            if (context.isPlatformSelected((Artifact)artifact)) {
                artifact.activate();
            }
        });
        Validator.validateGlobs(files.getGlobs(), "files.glob", errors);
    }
}

