/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.SftpDownloader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SftpDownloaderValidator {
    private SftpDownloaderValidator() {
    }

    public static void validateSftpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, SftpDownloader> sftp = context.getModel().getDownload().getSftp();
        if (!sftp.isEmpty()) {
            context.getLogger().debug("download.sftp");
        }
        for (Map.Entry<String, SftpDownloader> e : sftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            SftpDownloaderValidator.validateSftpDownloader(context, e.getValue(), errors);
        }
    }

    private static void validateSftpDownloader(JReleaserContext context, SftpDownloader sftp, Errors errors) {
        context.getLogger().debug("download.sftp.{}", new Object[]{sftp.getName()});
        Validator.resolveActivatable(context, (Activatable)sftp, CollectionUtils.listOf((Object[])new String[]{"download.sftp." + sftp.getName(), "download.sftp"}), "ALWAYS");
        if (!sftp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        SshValidator.validateSsh(context, sftp, sftp.getType(), sftp.getName(), "download.", errors);
        Validator.validateTimeout(sftp);
        if (sftp.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"download.sftp." + sftp.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : sftp.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"download.sftp." + sftp.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

