/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.mustachejava.TemplateFunction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;

public final class Screenshot
extends AbstractModelObject<Screenshot>
implements Domain,
ExtraProperties {
    private static final long serialVersionUID = 7278270297286736205L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private Screenshot.Type type = Screenshot.Type.SOURCE;
    private Boolean primary;
    private String url;
    private String caption;
    private Integer width;
    private Integer height;
    @JsonIgnore
    private final org.jreleaser.model.api.common.Screenshot immutable = new org.jreleaser.model.api.common.Screenshot(){
        private static final long serialVersionUID = 3229726441750227017L;

        public Screenshot.Type getType() {
            return Screenshot.this.type;
        }

        public boolean isPrimary() {
            return Screenshot.this.isPrimary();
        }

        public String getUrl() {
            return Screenshot.this.url;
        }

        public String getCaption() {
            return Screenshot.this.caption;
        }

        public Integer getWidth() {
            return Screenshot.this.width;
        }

        public Integer getHeight() {
            return Screenshot.this.height;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Screenshot.this.asMap(full));
        }

        public String getPrefix() {
            return Screenshot.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Screenshot.this.extraProperties);
        }
    };

    public org.jreleaser.model.api.common.Screenshot asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Screenshot source) {
        this.type = this.merge(this.type, source.type);
        this.primary = this.merge(this.primary, source.primary);
        this.url = this.merge(this.url, source.url);
        this.caption = this.merge(this.caption, source.caption);
        this.width = this.merge(this.width, source.width);
        this.height = this.merge(this.height, source.height);
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    public Screenshot.Type getType() {
        return this.type;
    }

    public void setType(Screenshot.Type type) {
        this.type = type;
    }

    public void setType(String str) {
        this.setType(Screenshot.Type.of((String)str));
    }

    public boolean isPrimary() {
        return null != this.primary && this.primary != false;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public String prefix() {
        return "screenshot";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", this.type);
        map.put("url", this.url);
        if (this.isPrimary()) {
            map.put("primary", this.isPrimary());
        }
        map.put("caption", this.caption);
        map.put("width", this.width);
        map.put("height", this.height);
        map.put("extraProperties", this.resolvedExtraProperties());
        return map;
    }

    public ScreenshotTemplate asScreenshotTemplate() {
        return new ScreenshotTemplate(this);
    }

    public static final class ScreenshotTemplate {
        private final String type;
        private final boolean primary;
        private final String url;
        private final String caption;
        private final Integer width;
        private final Integer height;

        public ScreenshotTemplate(Screenshot source) {
            this.type = source.type.toString();
            this.primary = source.isPrimary();
            this.url = source.url;
            this.caption = source.caption;
            this.width = source.width;
            this.height = source.height;
        }

        public String getType() {
            return this.type;
        }

        public TemplateFunction getUrl() {
            return s -> this.url;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public String getCaption() {
            return this.caption;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }
    }
}

