/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.spi.deploy.maven.MavenDeployer;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.sdk.tool.PomChecker;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.Errors;
import org.jreleaser.util.IoUtils;
import org.jreleaser.util.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractMavenDeployer<A extends org.jreleaser.model.api.deploy.maven.MavenDeployer, D extends org.jreleaser.model.internal.deploy.maven.MavenDeployer<A>>
implements MavenDeployer<A, D> {
    private static final Algorithm[] ALGORITHMS = new Algorithm[]{Algorithm.MD5, Algorithm.SHA_1, Algorithm.SHA_256, Algorithm.SHA_512};
    private static final String PACKAGING_JAR = "jar";
    private static final String PACKAGING_POM = "pom";
    private static final String PACKAGING_MAVEN_ARCHETYPE = "maven-archetype";
    protected final org.jreleaser.model.internal.JReleaserContext context;

    protected AbstractMavenDeployer(org.jreleaser.model.internal.JReleaserContext context) {
        this.context = context;
    }

    protected Set<Deployable> collectDeployables() {
        TreeSet<Deployable> deployables = new TreeSet<Deployable>();
        for (String stagingRepository : this.getDeployer().getStagingRepositories()) {
            Path root = this.context.getBasedir().resolve(stagingRepository).normalize();
            if (!Files.exists(root, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"maven." + this.getDeployer().getType() + "." + this.getDeployer().getName() + ".stagingRepository", this.context.relativizeToBasedir(root).toString()}));
            }
            if (!root.toFile().isDirectory()) {
                throw new JReleaserException(RB.$((String)"validation_is_not_a_directory", (Object[])new Object[]{"maven." + this.getDeployer().getType() + "." + this.getDeployer().getName() + ".stagingRepository", this.context.relativizeToBasedir(root).toString()}));
            }
            try {
                DeployableCollector collector = new DeployableCollector(root);
                Files.walkFileTree(root, collector);
                if (collector.failed) {
                    throw new JReleaserException(RB.$((String)"ERROR_deployer_stage_resolution", (Object[])new Object[0]));
                }
                deployables.addAll(collector.deployables);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_deployer_unexpected_error_stage", (Object[])new Object[0]), (Throwable)e);
            }
        }
        Map<String, Deployable> deployablesMap = deployables.stream().collect(Collectors.toMap(Deployable::getFilename, Function.identity()));
        Errors errors = new Errors();
        this.checkMavenCentralRules(deployablesMap, errors);
        if (errors.hasErrors()) {
            errors.logErrors(this.context.getLogger());
            throw new JReleaserException(RB.$((String)"ERROR_deployer_maven_central_rules", (Object[])new Object[0]));
        }
        this.signDeployables(deployablesMap, deployables);
        this.checksumDeployables(deployablesMap, deployables);
        return deployables;
    }

    private void checkMavenCentralRules(Map<String, Deployable> deployablesMap, Errors errors) {
        if (!this.getDeployer().isApplyMavenCentralRules()) {
            return;
        }
        for (Deployable deployable : deployablesMap.values()) {
            Deployable derived;
            if (!deployable.getFilename().endsWith(".pom")) continue;
            String base = deployable.getFilename();
            base = base.substring(0, base.length() - 4);
            if (deployable.requiresJar() && !deployablesMap.containsKey((derived = deployable.deriveByFilename(PACKAGING_JAR, base + ".jar")).getFilename())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
            }
            if (deployable.requiresSourcesJar() && !deployablesMap.containsKey((derived = deployable.deriveByFilename(PACKAGING_JAR, base + "-sources.jar")).getFilename())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
            }
            if (!deployable.requiresJavadocJar() || deployablesMap.containsKey((derived = deployable.deriveByFilename(PACKAGING_JAR, base + "-javadoc.jar")).getFilename())) continue;
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
        }
        if (!this.getDeployer().isVerifyPom()) {
            return;
        }
        PomChecker pomChecker = new PomChecker(this.context.asImmutable(), DefaultVersions.getInstance().getPomcheckerVersion());
        try {
            if (!pomChecker.setup()) {
                this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"pomchecker"}));
                return;
            }
        }
        catch (ToolException e) {
            this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"pomchecker"}), (Throwable)e);
            return;
        }
        for (Deployable deployable : deployablesMap.values()) {
            if (!deployable.getFilename().endsWith(".pom")) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ArrayList<String> args = new ArrayList<String>();
            args.add("check-maven-central");
            args.add("--quiet");
            if (this.context.getModel().getProject().isSnapshot() && this.getDeployer().isSnapshotAllowed()) {
                args.add("--no-release");
            }
            args.add("--file");
            args.add(deployable.getLocalPath().toAbsolutePath().toString());
            try {
                pomChecker.invoke(this.context.getBasedir(), args, (OutputStream)out, (OutputStream)err);
            }
            catch (CommandException e) {
                String plumbing = IoUtils.toString((ByteArrayOutputStream)err).trim();
                String validation = IoUtils.toString((ByteArrayOutputStream)out).trim();
                if (StringUtils.isNotBlank((String)validation)) {
                    errors.configuration(validation);
                    continue;
                }
                if (StringUtils.isNotBlank((String)plumbing)) {
                    errors.configuration(plumbing);
                    continue;
                }
                errors.configuration(e.getMessage());
            }
        }
    }

    private void signDeployables(Map<String, Deployable> deployablesMap, Set<Deployable> deployables) {
        if (!this.getDeployer().isSign()) {
            return;
        }
        for (Deployable deployable : deployablesMap.values()) {
            Deployable signedDeployable;
            if (!deployable.getFilename().endsWith(".jar") && !deployable.getFilename().endsWith(".pom") || deployablesMap.containsKey((signedDeployable = deployable.deriveByFilename(deployable.getFilename() + ".asc")).getFilename())) continue;
            try {
                this.context.getLogger().setPrefix("sign");
                SigningUtils.sign((JReleaserContext)this.context.asImmutable(), (Path)deployable.getLocalPath());
                deployables.add(signedDeployable);
            }
            catch (SigningException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_signing_file", (Object[])new Object[]{deployable.getFilename()}), (Throwable)e);
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    private void checksumDeployables(Map<String, Deployable> deployablesMap, Set<Deployable> deployables) {
        for (Deployable deployable : deployablesMap.values()) {
            if (!deployable.getFilename().endsWith(".jar") && !deployable.getFilename().endsWith(".pom") && !deployable.getFilename().endsWith(".asc")) continue;
            if (deployable.getFilename().endsWith(".asc")) {
                for (Algorithm algorithm : ALGORITHMS) {
                    Deployable checksumDeployable = deployable.deriveByFilename(deployable.getFilename() + "." + algorithm.formatted());
                    deployables.remove(checksumDeployable);
                }
                continue;
            }
            try {
                byte[] data = Files.readAllBytes(deployable.getLocalPath());
                for (Algorithm algorithm : ALGORITHMS) {
                    Deployable checksumDeployable = deployable.deriveByFilename(deployable.getFilename() + "." + algorithm.formatted());
                    if (deployablesMap.containsKey(checksumDeployable.getFilename())) continue;
                    this.context.getLogger().debug(RB.$((String)"checksum.calculating", (Object[])new Object[]{algorithm.formatted(), deployable.getFilename()}));
                    String checksum = ChecksumUtils.checksum((Algorithm)algorithm, (byte[])data);
                    Files.write(checksumDeployable.getLocalPath(), checksum.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    deployables.add(checksumDeployable);
                }
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_calculate_checksum", (Object[])new Object[]{deployable.getFilename()}), (Throwable)e);
            }
        }
    }

    private class DeployableCollector
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final Set<Deployable> deployables = new TreeSet<Deployable>();
        private final List<PathMatcher> matchers = new ArrayList<PathMatcher>();
        private boolean failed;

        public DeployableCollector(Path root) {
            this.root = root;
            FileSystem fileSystem = FileSystems.getDefault();
            String[] extensions = new String[]{".jar", ".jar.asc", ".pom", ".pom.asc"};
            String[] checksums = new String[]{".md5", ".sha1", ".sha256", ".sha512"};
            for (String ext : extensions) {
                this.matchers.add(fileSystem.getPathMatcher("glob:**/*" + ext));
                for (String cs : checksums) {
                    this.matchers.add(fileSystem.getPathMatcher("glob:**/*" + ext + cs));
                }
            }
        }

        private void match(Path path) {
            if (this.matchers.stream().anyMatch(matcher -> matcher.matches(path))) {
                String stagingRepository = this.root.toAbsolutePath().toString();
                String stagingPath = path.getParent().toAbsolutePath().toString();
                this.deployables.add(new Deployable(stagingRepository, stagingPath.substring(stagingRepository.length()), this.resolvePackaging(path), path.getFileName().toString()));
            }
        }

        private String resolvePackaging(Path artifactPath) {
            if (!artifactPath.getFileName().toString().endsWith(".pom")) {
                return AbstractMavenDeployer.PACKAGING_JAR;
            }
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(artifactPath.toFile());
                String query = "/project/packaging";
                String packaging = (String)XPathFactory.newInstance().newXPath().compile(query).evaluate(document, XPathConstants.STRING);
                return StringUtils.isNotBlank((String)packaging) ? packaging.trim() : AbstractMavenDeployer.PACKAGING_JAR;
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            AbstractMavenDeployer.this.context.getLogger().trace((Throwable)e);
            AbstractMavenDeployer.this.context.getLogger().error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[0]), new Object[]{this.root.toAbsolutePath().relativize(file.toAbsolutePath()), e});
            return FileVisitResult.CONTINUE;
        }
    }

    public static class Deployable
    implements Comparable<Deployable> {
        private final String stagingRepository;
        private final String path;
        private final String filename;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String packaging;

        public Deployable(String stagingRepository, String path, String filename) {
            this(stagingRepository, path, AbstractMavenDeployer.PACKAGING_JAR, filename);
        }

        public Deployable(String stagingRepository, String path, String packaging, String filename) {
            this.stagingRepository = stagingRepository;
            this.path = path;
            this.filename = filename;
            this.packaging = packaging;
            Path p = Paths.get(path, new String[0]);
            this.version = p.getFileName().toString();
            p = p.getParent();
            this.artifactId = p.getFileName().toString();
            p = p.getParent();
            String gid = p.toString().replace("/", ".").replace("\\", ".");
            if (gid.startsWith(".")) {
                gid = gid.substring(1);
            }
            this.groupId = gid;
        }

        public boolean requiresJar() {
            return !AbstractMavenDeployer.PACKAGING_POM.equals(this.packaging);
        }

        public boolean requiresSourcesJar() {
            return !AbstractMavenDeployer.PACKAGING_POM.equals(this.packaging);
        }

        public boolean requiresJavadocJar() {
            return !AbstractMavenDeployer.PACKAGING_POM.equals(this.packaging) && !AbstractMavenDeployer.PACKAGING_MAVEN_ARCHETYPE.equals(this.packaging);
        }

        public String getGav() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public String getStagingRepository() {
            return this.stagingRepository;
        }

        public String getPath() {
            return this.path;
        }

        public String getDeployPath() {
            return this.path.replace("\\", "/");
        }

        public String getFilename() {
            return this.filename;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public Path getLocalPath() {
            return Paths.get(this.stagingRepository, this.path, this.filename);
        }

        public Deployable deriveByFilename(String filename) {
            return new Deployable(this.stagingRepository, this.path, this.packaging, filename);
        }

        public Deployable deriveByFilename(String packaging, String filename) {
            return new Deployable(this.stagingRepository, this.path, packaging, filename);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deployable that = (Deployable)o;
            return this.stagingRepository.equals(that.stagingRepository) && this.path.equals(that.path) && this.filename.equals(that.filename);
        }

        public int hashCode() {
            return Objects.hash(this.stagingRepository, this.path, this.filename);
        }

        @Override
        public int compareTo(Deployable o) {
            if (o == null) {
                return -1;
            }
            return this.filename.compareTo(o.filename);
        }
    }
}

