/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.workflow;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.changelog.Changelog;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.workflow.AbstractWorkflowItem;

class ChangelogWorkflowItem
extends AbstractWorkflowItem {
    private static final String JRELEASER_CHANGELOG_ANCHOR = "<!-- JRELEASER_CHANGELOG_APPEND - Do not remove or modify this section -->";

    protected ChangelogWorkflowItem() {
        super(JReleaserCommand.CHANGELOG);
    }

    @Override
    protected void doInvoke(JReleaserContext context) {
        String resolvedChangelog = Changelog.createChangelog(context);
        context.setChangelog(resolvedChangelog);
        if (StringUtils.isNotBlank((String)resolvedChangelog) && context.getModel().getProject().isRelease() && context.getModel().getRelease().getReleaser().getChangelog().getAppend().isEnabled()) {
            this.appendChangelog(context, resolvedChangelog);
        }
    }

    private void appendChangelog(JReleaserContext context, String resolvedChangelog) {
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        Changelog.Append append = releaser.getChangelog().getAppend();
        Map props = context.fullProps();
        String resolvedTitle = MustacheUtils.applyTemplate((String)append.getTitle(), (Map)props);
        props = context.fullProps();
        props.put("changelogTitle", MustacheUtils.passThrough((String)resolvedTitle));
        props.put("changelogContent", MustacheUtils.passThrough((String)resolvedChangelog));
        String appendableChangelog = StringUtils.stripMargin((String)MustacheUtils.applyTemplate((Reader)append.getResolvedContentTemplate(context), (Map)props));
        Path target = context.getBasedir().resolve(append.getTarget());
        String fullChangelog = null;
        try {
            fullChangelog = new String(Files.readAllBytes(target), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            context.getLogger().warn(RB.$((String)"ERROR_cannot_read_changelog", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(append.getTarget())});
        }
        String separator = this.separator(releaser);
        fullChangelog = fullChangelog.contains(JRELEASER_CHANGELOG_ANCHOR) ? fullChangelog.replaceFirst(JRELEASER_CHANGELOG_ANCHOR, JRELEASER_CHANGELOG_ANCHOR + separator + appendableChangelog + separator + separator) : appendableChangelog + separator + separator + fullChangelog;
        context.getLogger().info(RB.$((String)"changelog.generator.store", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(target)});
        try {
            Files.write(target, fullChangelog.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            context.getLogger().error(RB.$((String)"ERROR_unexpected_error_changelog_append", (Object[])new Object[0]));
        }
    }

    private String separator(BaseReleaser<?, ?> releaser) {
        String separator = System.lineSeparator();
        if ("gitlab".equals(releaser.getServiceName())) {
            separator = separator + System.lineSeparator();
        }
        return separator;
    }
}

