/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SnapPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.PlatformUtils;

public class SnapPackagerProcessor
extends AbstractRepositoryPackagerProcessor<SnapPackager> {
    public SnapPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((SnapPackager)this.packager).isRemoteBuild()) {
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createSnap(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        if (((SnapPackager)this.packager).isRemoteBuild()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.login(distribution, props);
        this.push(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String desc = this.context.getModel().getProject().getLongDescription();
        desc = Arrays.stream(desc.split(System.lineSeparator())).map(line -> "  " + line).collect(Collectors.joining(System.lineSeparator()));
        props.put("projectLongDescription", MustacheUtils.passThrough((String)("|" + System.lineSeparator() + desc)));
        props.put("snapRepoUrl", releaser.getResolvedRepoUrl(this.context.getModel(), ((SnapPackager)this.packager).getSnap().getOwner(), ((SnapPackager)this.packager).getSnap().getResolvedName()));
        props.put("snapRepoCloneUrl", releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((SnapPackager)this.packager).getSnap().getOwner(), ((SnapPackager)this.packager).getSnap().getResolvedName()));
        props.put("snapPackageName", ((SnapPackager)this.packager).getPackageName());
        props.put("snapBase", ((SnapPackager)this.packager).getBase());
        props.put("snapGrade", ((SnapPackager)this.packager).getGrade());
        props.put("snapConfinement", ((SnapPackager)this.packager).getConfinement());
        props.put("snapHasPlugs", !((SnapPackager)this.packager).getPlugs().isEmpty());
        props.put("snapPlugs", ((SnapPackager)this.packager).getPlugs());
        props.put("snapHasSlots", !((SnapPackager)this.packager).getSlots().isEmpty());
        props.put("snapSlots", ((SnapPackager)this.packager).getSlots());
        props.put("snapHasLocalPlugs", !((SnapPackager)this.packager).getLocalPlugs().isEmpty());
        props.put("snapLocalPlugs", ((SnapPackager)this.packager).getLocalPlugs());
        props.put("snapHasLocalSlots", !((SnapPackager)this.packager).getLocalSlots().isEmpty());
        props.put("snapLocalSlots", ((SnapPackager)this.packager).getLocalSlots());
        props.put("hasArchitectures", !((SnapPackager)this.packager).getArchitectures().isEmpty());
        props.put("snapArchitectures", ((SnapPackager)this.packager).getArchitectures());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void login(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Command cmd = new Command("snapcraft").arg("login").arg("--with").arg(this.context.getBasedir().resolve(distribution.getSnap().getExportedLogin()).toAbsolutePath().toString());
        this.executeCommand(cmd);
    }

    private void push(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((SnapPackager)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("push").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }

    private void createSnap(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((SnapPackager)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("snap").arg("--output").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }
}

