/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class JavaArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<org.jreleaser.model.api.assemble.JavaArchiveAssembler, JavaArchiveAssembler> {
    public JavaArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((JavaArchiveAssembler)this.assembler).getResolvedArchiveName(this.context);
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path workDirectory = assembleDirectory.resolve("work");
        Path archiveDirectory = workDirectory.resolve(archiveName);
        try {
            FileUtils.deleteFiles((Path)inputsDirectory);
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        try {
            this.context.getLogger().debug(RB.$((String)"packager.resolve.templates", (Object[])new Object[0]), new Object[]{((JavaArchiveAssembler)this.assembler).getType(), ((JavaArchiveAssembler)this.assembler).getName()});
            Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)((JavaArchiveAssembler)this.assembler).getType(), (String)((JavaArchiveAssembler)this.assembler).getType(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(((JavaArchiveAssembler)this.getAssembler()).getTemplateDirectory()));
            templates.putAll(TemplateUtils.resolveTemplates((Path)this.context.getBasedir().resolve(((JavaArchiveAssembler)this.getAssembler()).getTemplateDirectory())));
            for (Map.Entry entry : templates.entrySet()) {
                String key = (String)entry.getKey();
                TemplateResource value = (TemplateResource)entry.getValue();
                if (value.isReader()) {
                    this.context.getLogger().debug(RB.$((String)"packager.evaluate.template", (Object[])new Object[0]), new Object[]{key, ((JavaArchiveAssembler)this.assembler).getName(), ((JavaArchiveAssembler)this.assembler).getType()});
                    String content = MustacheUtils.applyTemplate((Reader)value.getReader(), props, (String)key);
                    this.context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{key, ((JavaArchiveAssembler)this.assembler).getName(), ((JavaArchiveAssembler)this.assembler).getType()});
                    this.writeFile(this.context.getModel().getProject(), content, props, key);
                    continue;
                }
                this.context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{key, ((JavaArchiveAssembler)this.assembler).getName(), ((JavaArchiveAssembler)this.assembler).getType()});
                this.writeFile(this.context.getModel().getProject(), IOUtils.toByteArray((InputStream)value.getInputStream()), props, key);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyFiles(this.context, archiveDirectory);
        this.copyFileSets(this.context, archiveDirectory);
        Path jarsDirectory = archiveDirectory.resolve("lib");
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(jarsDirectory)});
        JavaArchiveAssemblerProcessor.copyJars(this.context, (JavaArchiveAssembler)this.assembler, jarsDirectory);
        Path binDirectory = archiveDirectory.resolve("bin");
        try {
            Files.createDirectories(binDirectory, new FileAttribute[0]);
            String executableName = ((JavaArchiveAssembler)this.assembler).getExecutable().getName();
            Path launcher = inputsDirectory.resolve("bin").resolve(executableName.concat(".bat"));
            Files.copy(launcher, binDirectory.resolve(executableName.concat("." + ((JavaArchiveAssembler)this.assembler).getExecutable().getWindowsExtension())), new CopyOption[0]);
            launcher = inputsDirectory.resolve("bin").resolve(executableName);
            Files.copy(launcher, binDirectory.resolve(executableName), new CopyOption[0]);
            FileUtils.grantExecutableAccess((Path)launcher);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_launcher", (Object[])new Object[]{this.context.relativizeToBasedir(binDirectory)}), (Throwable)e);
        }
        for (Archive.Format format : ((JavaArchiveAssembler)this.assembler).getFormats()) {
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    @Override
    protected void fillAssemblerProperties(Map<String, Object> props) {
        super.fillAssemblerProperties(props);
        if (StringUtils.isNotBlank((String)((JavaArchiveAssembler)this.assembler).getMainJar().getPath())) {
            props.put("distributionJavaMainJar", ((JavaArchiveAssembler)this.assembler).getMainJar().getEffectivePath(this.context, this.assembler).getFileName());
        } else {
            props.put("distributionJavaMainJar", "");
        }
        props.put("distributionJavaMainClass", ((JavaArchiveAssembler)this.assembler).getJava().getMainClass());
        props.put("distributionJavaMainModule", ((JavaArchiveAssembler)this.assembler).getJava().getMainModule());
        props.put("distributionJavaOptions", !((JavaArchiveAssembler)this.assembler).getJava().getOptions().isEmpty() ? ((JavaArchiveAssembler)this.assembler).getJava().getOptions() : "");
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            FileUtils.packArchive((Path)workDirectory, (Path)archiveFile, (ZonedDateTime)this.context.getModel().resolveArchiveTimestamp());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Set<Path> copyFiles(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (Glob glob : ((JavaArchiveAssembler)this.assembler).getFiles()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{path.getFileName()});
                Files.copy(path, destination.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
        return paths;
    }

    private void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = outputDirectory.resolve("inputs");
        try {
            Files.createDirectories(inputsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        String executableName = ((JavaArchiveAssembler)this.assembler).getExecutable().getName();
        Path outputFile = "launcher.bat".equals(fileName) ? inputsDirectory.resolve("bin").resolve(executableName.concat(".bat")) : ("launcher".equals(fileName) ? inputsDirectory.resolve("bin").resolve(executableName) : inputsDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }

    private void writeFile(Project project, byte[] content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = outputDirectory.resolve("inputs");
        try {
            Files.createDirectories(inputsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path outputFile = inputsDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private static Set<Path> copyJars(JReleaserContext context, JavaArchiveAssembler assembler, Path jarsDirectory) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        if (StringUtils.isNotBlank((String)assembler.getMainJar().getPath())) {
            paths.add(assembler.getMainJar().getEffectivePath(context, (Assembler)assembler));
        }
        for (Glob glob : assembler.getJars()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, (Assembler)assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(jarsDirectory, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{path.getFileName()});
                Files.copy(path, jarsDirectory.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_jars", (Object[])new Object[0]), (Throwable)e);
        }
        return paths;
    }
}

