/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.HttpUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpUploaderValidator
extends Validator {
    public static void validateHttpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, HttpUploader> http = context.getModel().getUpload().getHttp();
        if (!http.isEmpty()) {
            context.getLogger().debug("upload.http");
        }
        for (Map.Entry<String, HttpUploader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            HttpUploaderValidator.validateHttp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, HttpUploader http, Errors errors) {
        context.getLogger().debug("upload.http.{}", new Object[]{http.getName()});
        if (!http.isActiveSet()) {
            http.setActive(Active.NEVER);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(http.isArtifacts() || http.isFiles() || http.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{http.getType(), http.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            http.disable();
            return;
        }
        if (StringUtils.isBlank((String)http.getUploadUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"http." + http.getName() + ".uploadUrl"}));
        }
        if (StringUtils.isBlank((String)http.getDownloadUrl())) {
            http.setDownloadUrl(http.getUploadUrl());
        }
        if (null == http.getMethod()) {
            http.setMethod(Http.Method.PUT);
        }
        String baseKey = "upload.http." + http.getName() + ".";
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", baseKey + "password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_USERNAME", baseKey + "username", http.getUsername(), errors, context.isDryrun()));
                http.setPassword(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", baseKey + "password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        HttpUploaderValidator.validateTimeout(http);
    }
}

