/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class NativeImageAssemblerResolver
extends Validator {
    public static void resolveNativeImageOutputs(JReleaserContext context, Errors errors) {
        List<NativeImageAssembler> activeNativeImages = context.getModel().getAssemble().getActiveNativeImages();
        if (!activeNativeImages.isEmpty()) {
            context.getLogger().debug("assemble.nativeImage");
        }
        for (NativeImageAssembler nativeImage : activeNativeImages) {
            if (!nativeImage.isExported()) continue;
            NativeImageAssemblerResolver.resolveNativeImageOutputs(context, nativeImage, errors);
        }
    }

    private static void resolveNativeImageOutputs(JReleaserContext context, NativeImageAssembler nativeImage, Errors errors) {
        if (!context.isPlatformSelected(nativeImage.getGraal())) {
            return;
        }
        String imageName = nativeImage.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)nativeImage.getImageNameTransform())) {
            imageName = nativeImage.getResolvedImageNameTransform(context);
        }
        String platform = nativeImage.getGraal().getPlatform();
        String platformReplaced = nativeImage.getPlatform().applyReplacements(platform);
        Path image = context.getAssembleDirectory().resolve(nativeImage.getName()).resolve(nativeImage.getType()).resolve(imageName + "-" + platformReplaced + "." + nativeImage.getArchiveFormat().extension());
        if (!Files.exists(image, new LinkOption[0])) {
            errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{nativeImage.getType(), nativeImage.getName(), nativeImage.getName()}));
        } else {
            Artifact artifact = Artifact.of(image, platform);
            artifact.setExtraProperties(nativeImage.getExtraProperties());
            artifact.activate();
            nativeImage.addOutput(artifact);
        }
    }
}

