/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.DockerConfiguration;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.StringUtils;

public abstract class AbstractDockerConfiguration<S extends AbstractDockerConfiguration<S>>
extends AbstractModelObject<S>
implements DockerConfiguration,
ExtraProperties,
Activatable {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final Map<String, String> labels = new LinkedHashMap<String, String>();
    protected final Set<String> imageNames = new LinkedHashSet<String>();
    protected final List<String> buildArgs = new ArrayList<String>();
    protected final List<String> preCommands = new ArrayList<String>();
    protected final List<String> postCommands = new ArrayList<String>();
    protected final Set<DockerConfiguration.Registry> registries = new LinkedHashSet<DockerConfiguration.Registry>();
    protected final List<String> skipTemplates = new ArrayList<String>();
    protected final DockerConfiguration.Buildx buildx = new DockerConfiguration.Buildx();
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected String templateDirectory;
    protected Boolean useLocalArtifact;
    protected String baseImage;

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractDockerConfiguration)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractDockerConfiguration)source).enabled);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractDockerConfiguration)source).templateDirectory);
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractDockerConfiguration)source).skipTemplates));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractDockerConfiguration)source).extraProperties));
        this.baseImage = this.merge(this.baseImage, ((AbstractDockerConfiguration)source).baseImage);
        this.useLocalArtifact = this.merge(this.useLocalArtifact, ((AbstractDockerConfiguration)source).useLocalArtifact);
        this.setImageNames(this.merge(this.imageNames, ((AbstractDockerConfiguration)source).imageNames));
        this.setBuildArgs(this.merge(this.buildArgs, ((AbstractDockerConfiguration)source).buildArgs));
        this.setPreCommands(this.merge(this.preCommands, ((AbstractDockerConfiguration)source).preCommands));
        this.setPostCommands(this.merge(this.postCommands, ((AbstractDockerConfiguration)source).postCommands));
        this.setLabels(this.merge(this.labels, ((AbstractDockerConfiguration)source).labels));
        this.setRegistries(this.merge(this.registries, ((AbstractDockerConfiguration)source).registries));
        this.setBuildx(((AbstractDockerConfiguration)source).buildx);
    }

    @Override
    public String getPrefix() {
        return "docker";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    public boolean resolveEnabled(Project project, Distribution distribution) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.skipTemplates;
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        this.labels.clear();
        this.labels.putAll(labels);
    }

    @Override
    public void addLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
    }

    @Override
    public void addLabel(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.labels.put(key, value);
        }
    }

    @Override
    public Set<String> getImageNames() {
        return this.imageNames;
    }

    @Override
    public void setImageNames(Set<String> imageNames) {
        if (imageNames != null) {
            this.imageNames.clear();
            this.imageNames.addAll(imageNames);
        }
    }

    @Override
    public void addImageName(String imageName) {
        if (StringUtils.isNotBlank((String)imageName)) {
            this.imageNames.add(imageName);
        }
    }

    @Override
    public List<String> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public void setBuildArgs(List<String> buildArgs) {
        if (buildArgs != null) {
            this.buildArgs.clear();
            this.buildArgs.addAll(buildArgs);
        }
    }

    @Override
    public void addBuildArg(String buildArg) {
        if (StringUtils.isNotBlank((String)buildArg)) {
            this.buildArgs.add(buildArg);
        }
    }

    @Override
    public List<String> getPreCommands() {
        return this.preCommands;
    }

    @Override
    public void setPreCommands(List<String> preCommands) {
        if (preCommands != null) {
            this.preCommands.clear();
            this.preCommands.addAll(preCommands);
        }
    }

    @Override
    public List<String> getPostCommands() {
        return this.postCommands;
    }

    @Override
    public void setPostCommands(List<String> postCommands) {
        if (postCommands != null) {
            this.postCommands.clear();
            this.postCommands.addAll(postCommands);
        }
    }

    public Set<DockerConfiguration.Registry> getRegistries() {
        return this.registries;
    }

    @Override
    public void setRegistries(Set<? extends DockerConfiguration.Registry> registries) {
        if (registries != null) {
            this.registries.clear();
            this.registries.addAll(registries);
        }
    }

    @Override
    public void addRegistry(DockerConfiguration.Registry registry) {
        if (null != registry) {
            this.registries.add(registry);
        }
    }

    @Override
    public boolean isUseLocalArtifact() {
        return this.useLocalArtifact == null || this.useLocalArtifact != false;
    }

    @Override
    public void setUseLocalArtifact(Boolean useLocalArtifact) {
        this.useLocalArtifact = useLocalArtifact;
    }

    @Override
    public boolean isUseLocalArtifactSet() {
        return this.useLocalArtifact != null;
    }

    @Override
    public DockerConfiguration.Buildx getBuildx() {
        return this.buildx;
    }

    @Override
    public void setBuildx(DockerConfiguration.Buildx buildx) {
        this.buildx.merge(buildx);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
        props.put("useLocalArtifact", this.isUseLocalArtifact());
        props.put("baseImage", this.baseImage);
        props.put("imageNames", this.imageNames);
        props.put("buildArgs", this.buildArgs);
        props.put("labels", this.labels);
        props.put("preCommands", this.preCommands);
        props.put("postCommands", this.postCommands);
        if (this.buildx.isEnabled() || full) {
            props.put("buildx", this.buildx.asMap(full));
        }
        this.asMap(full, props);
        List repos = this.registries.stream().map(r -> r.asMap(full)).collect(Collectors.toList());
        if (!repos.isEmpty()) {
            props.put("registries", repos);
        }
        props.put("extraProperties", this.getResolvedExtraProperties());
        return props;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

