/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.sdk.twitter.UpdateStatusTwitterCommand;
import org.jreleaser.util.StringUtils;

public class TwitterAnnouncer
implements Announcer<org.jreleaser.model.api.announce.TwitterAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.TwitterAnnouncer twitter;

    public TwitterAnnouncer(JReleaserContext context) {
        this.context = context;
        this.twitter = context.getModel().getAnnounce().getTwitter();
    }

    public org.jreleaser.model.api.announce.TwitterAnnouncer getAnnouncer() {
        return this.twitter.asImmutable();
    }

    public String getName() {
        return "twitter";
    }

    public boolean isEnabled() {
        return this.twitter.isEnabled();
    }

    public void announce() throws AnnounceException {
        ArrayList<String> statuses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.twitter.getStatusTemplate())) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            Arrays.stream(this.twitter.getResolvedStatusTemplate(this.context, props).split(System.lineSeparator())).filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty() && !this.twitter.getStatuses().isEmpty()) {
            statuses.addAll(this.twitter.getStatuses());
            this.twitter.getStatuses().stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty()) {
            statuses.add(this.twitter.getStatus());
        }
        for (int i = 0; i < statuses.size(); ++i) {
            String status = this.getResolvedMessage(this.context, (String)statuses.get(i));
            this.context.getLogger().info(RB.$((String)"twitter.tweet", (Object[])new Object[0]), new Object[]{status});
            this.context.getLogger().debug(RB.$((String)"twitter.tweet.size", (Object[])new Object[0]), new Object[]{status.length()});
            statuses.set(i, status);
        }
        try {
            ((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)UpdateStatusTwitterCommand.builder(this.context.getLogger()).connectTimeout(this.twitter.getConnectTimeout())).readTimeout(this.twitter.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getResolvedConsumerSecret())).accessToken(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getResolvedAccessToken())).accessTokenSecret(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getResolvedAccessTokenSecret())).statuses(statuses).dryrun(this.context.isDryrun())).build().execute();
        }
        catch (TwitterException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private String getResolvedMessage(JReleaserContext context, String message) {
        Map props = context.fullProps();
        MustacheUtils.applyTemplates((Map)props, (Map)context.getModel().getAnnounce().getTwitter().getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        return Templates.resolveTemplate((String)message, (Map)props);
    }
}

