/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Locale;
import java.util.function.Predicate;
import org.jreleaser.util.StringUtils;

public enum Active {
    ALWAYS(project -> true),
    NEVER(project -> false),
    RELEASE(Releaseable::isRelease),
    PRERELEASE(project -> true),
    RELEASE_PRERELEASE(Releaseable::isRelease),
    SNAPSHOT(r -> !r.isRelease());

    private final Predicate<Releaseable> test;

    private Active(Predicate<Releaseable> test) {
        this.test = test;
    }

    public boolean check(Releaseable project) {
        return this.test.test(project);
    }

    public boolean check(Releaseable project, Prereleaseable service) {
        boolean p = this.test.test(project);
        if (p && (this == PRERELEASE || this == RELEASE_PRERELEASE)) {
            return service.isPrerelease();
        }
        return p;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static Active of(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return Active.valueOf(str.toUpperCase(Locale.ENGLISH).trim().replace("+", "_").replace("-", "_").replace(" ", "_"));
    }

    public static interface Prereleaseable {
        public boolean isPrerelease();
    }

    public static interface Releaseable {
        public boolean isRelease();
    }
}

