/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.discord;

import java.util.LinkedHashMap;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.discord.Message;
import org.jreleaser.util.StringUtils;

public class DiscordAnnouncer
implements Announcer<org.jreleaser.model.api.announce.DiscordAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.DiscordAnnouncer discord;

    public DiscordAnnouncer(JReleaserContext context) {
        this.context = context;
        this.discord = context.getModel().getAnnounce().getDiscord();
    }

    public org.jreleaser.model.api.announce.DiscordAnnouncer getAnnouncer() {
        return this.discord.asImmutable();
    }

    public String getName() {
        return "discord";
    }

    public boolean isEnabled() {
        return this.discord.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.discord.getMessage())) {
            message = this.discord.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.discord.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.discord.getResolvedWebhook(), (int)this.discord.getConnectTimeout(), (int)this.discord.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

