/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.templates;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.InputStreamTemplateResource;
import org.jreleaser.templates.ReaderTemplateResource;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.util.StringUtils;

public final class TemplateUtils {
    private static final Properties TEMPLATES_INVENTORY = new Properties();
    private static final String BASE_TEMPLATE_PREFIX = "META-INF/jreleaser/templates/";
    private static final String TPL = ".tpl";

    private TemplateUtils() {
    }

    public static String trimTplExtension(String str) {
        if (str.endsWith(TPL)) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    public static Map<String, TemplateResource> resolveAndMergeTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        Map<String, TemplateResource> templates = TemplateUtils.resolveTemplates(logger, distributionType, toolName, snapshot);
        if (null != templateDirectory && Files.exists(templateDirectory, new LinkOption[0])) {
            templates.putAll(TemplateUtils.resolveTemplates(distributionType, toolName, snapshot, templateDirectory));
        }
        return templates;
    }

    public static Map<String, TemplateResource> resolveTemplates(String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        final LinkedHashMap<String, TemplateResource> templates = new LinkedHashMap<String, TemplateResource>();
        Path snapshotTemplateDirectory = templateDirectory.resolveSibling(templateDirectory.getFileName() + "-snapshot");
        Path directory = templateDirectory;
        if (snapshot && snapshotTemplateDirectory.toFile().exists()) {
            directory = snapshotTemplateDirectory;
        }
        final Path actualTemplateDirectory = directory;
        try {
            Files.walkFileTree(actualTemplateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(actualTemplateDirectory.relativize(file).toString(), TemplateUtils.asResource(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            String distributionTypeName = distributionType.toLowerCase(Locale.ENGLISH).replace('_', '-');
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_distribution", (Object[])new Object[]{distributionTypeName, toolName, actualTemplateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    public static Map<String, TemplateResource> resolveTemplates(final Path templateDirectory) {
        final LinkedHashMap<String, TemplateResource> templates = new LinkedHashMap<String, TemplateResource>();
        try {
            Files.walkFileTree(templateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(templateDirectory.relativize(file).toString(), TemplateUtils.asResource(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_from", (Object[])new Object[]{templateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    private static TemplateResource asResource(Path file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file.toFile());
        if (file.getFileName().toString().endsWith(TPL)) {
            return new ReaderTemplateResource(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        }
        return new InputStreamTemplateResource(inputStream);
    }

    public static Map<String, TemplateResource> resolveTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot) {
        String distributionTypeName = distributionType.toLowerCase(Locale.ENGLISH).replace('_', '-');
        LinkedHashMap<String, TemplateResource> templates = new LinkedHashMap<String, TemplateResource>();
        logger.debug(RB.$((String)"templates.templates.resolve.classpath", (Object[])new Object[0]));
        String templatePrefix = distributionTypeName + "." + toolName.toLowerCase(Locale.ENGLISH) + (snapshot ? "-snapshot" : "");
        logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[]{templatePrefix}));
        String values = TEMPLATES_INVENTORY.getProperty(templatePrefix);
        if (StringUtils.isBlank((String)values) && snapshot) {
            templatePrefix = distributionTypeName + "." + toolName.toLowerCase(Locale.ENGLISH);
            logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[]{templatePrefix}));
            values = TEMPLATES_INVENTORY.getProperty(templatePrefix);
        }
        if (StringUtils.isNotBlank((String)values)) {
            for (String k : values.split(",")) {
                templates.put(k, TemplateUtils.resolveTemplate(logger, distributionTypeName + "/" + toolName.toLowerCase(Locale.ENGLISH) + "/" + k));
            }
        }
        return templates;
    }

    public static TemplateResource resolveTemplate(JReleaserLogger logger, String templateKey) {
        logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[0]), new Object[]{templateKey});
        try {
            InputStream inputStream = TemplateUtils.class.getClassLoader().getResourceAsStream(BASE_TEMPLATE_PREFIX + templateKey);
            if (null == inputStream) {
                throw new JReleaserException(RB.$((String)"ERROR_template_not_found", (Object[])new Object[]{BASE_TEMPLATE_PREFIX + templateKey}));
            }
            return templateKey.endsWith(TPL) ? new ReaderTemplateResource(new InputStreamReader(inputStream, StandardCharsets.UTF_8)) : new InputStreamTemplateResource(inputStream);
        }
        catch (Exception e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_template_for", (Object[])new Object[]{templateKey, "classpath"}));
        }
    }

    public static TemplateResource resolveResource(JReleaserLogger logger, String key) {
        logger.debug(RB.$((String)"templates.resource.resolve.classpath", (Object[])new Object[0]), new Object[]{key});
        try {
            InputStream inputStream = TemplateUtils.class.getClassLoader().getResourceAsStream(key);
            if (null == inputStream) {
                throw new JReleaserException(RB.$((String)"ERROR_resource_not_found", (Object[])new Object[]{key}));
            }
            return new InputStreamTemplateResource(inputStream);
        }
        catch (Exception e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_resource_for", (Object[])new Object[]{key, "classpath"}), (Throwable)e);
        }
    }

    static {
        try {
            TEMPLATES_INVENTORY.load(TemplateUtils.class.getResourceAsStream("/META-INF/jreleaser/templates.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

