/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.model.spi.assemble.AssemblerProcessor;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

abstract class AbstractAssemblerProcessor<A extends org.jreleaser.model.api.assemble.Assembler, S extends Assembler<A>>
implements AssemblerProcessor<A, S> {
    protected final JReleaserContext context;
    protected S assembler;

    protected AbstractAssemblerProcessor(JReleaserContext context) {
        this.context = context;
    }

    public S getAssembler() {
        return this.assembler;
    }

    public void setAssembler(S assembler) {
        this.assembler = assembler;
    }

    public void assemble(Map<String, Object> props) throws AssemblerProcessingException {
        try {
            this.context.getLogger().debug(RB.$((String)"packager.create.properties", (Object[])new Object[0]), new Object[]{this.assembler.getType(), this.assembler.getName()});
            Map<String, Object> newProps = this.fillProps(props);
            Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
            Files.createDirectories(assembleDirectory, new FileAttribute[0]);
            this.doAssemble(newProps);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    protected abstract void doAssemble(Map<String, Object> var1) throws AssemblerProcessingException;

    protected void writeFile(String content, Path outputFile) throws AssemblerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(byte[] content, Path outputFile) throws AssemblerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected Map<String, Object> fillProps(Map<String, Object> props) throws AssemblerProcessingException {
        LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
        this.context.getLogger().debug(RB.$((String)"packager.fill.git.properties", (Object[])new Object[0]));
        this.context.getModel().getRelease().getReleaser().fillProps(newProps, this.context.getModel());
        this.context.getLogger().debug(RB.$((String)"assembler.fill.assembler.properties", (Object[])new Object[0]));
        this.fillAssemblerProperties(newProps);
        MustacheUtils.applyTemplates(props, props);
        return newProps;
    }

    protected void fillAssemblerProperties(Map<String, Object> props) {
        props.putAll(this.assembler.props());
    }

    protected void executeCommand(Path directory, Command command) throws AssemblerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(directory, command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommand(Command command) throws AssemblerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandCapturing(Command command, OutputStream out) throws AssemblerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandCapturing(command, out);
            if (exitValue != 0) {
                this.context.getLogger().error(out.toString().trim());
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandCapturing(Path directory, Command command, OutputStream out) throws AssemblerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandCapturing(directory, command, out);
            if (exitValue != 0) {
                this.context.getLogger().error(out.toString().trim());
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyFileSets(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        try {
            for (FileSet fileSet : this.assembler.getFileSets()) {
                Path src = context.getBasedir().resolve(fileSet.getResolvedInput(context));
                Path dest = destination;
                String output = fileSet.getResolvedOutput(context);
                if (StringUtils.isNotBlank((String)output)) {
                    dest = destination.resolve(output);
                }
                Set paths = fileSet.getResolvedPaths(context);
                FileUtils.copyFiles((JReleaserLogger)context.getLogger(), (Path)src, (Path)dest, (Set)paths);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected String maybeQuote(String str) {
        return PlatformUtils.isWindows() ? StringUtils.quote((String)str) : str;
    }
}

