/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Mail;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SmtpAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SmtpAnnouncerValidator
extends Validator {
    public static void validateSmtp(JReleaserContext context, SmtpAnnouncer smtp, Errors errors) {
        context.getLogger().debug("announce.mail");
        if (!smtp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (null == smtp.getTransport()) {
            smtp.setTransport(Mail.Transport.SMTP);
        }
        if (StringUtils.isBlank((String)smtp.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.host"}));
        }
        if (null == smtp.getPort()) {
            smtp.setPort(25);
        }
        if (!smtp.isAuthSet()) {
            smtp.setAuth(true);
        }
        if (StringUtils.isBlank((String)smtp.getUsername())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.username"}));
        }
        smtp.setPassword(SmtpAnnouncerValidator.checkProperty(context, "MAIL_PASSWORD", "mail.password", smtp.getPassword(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)smtp.getFrom())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.from"}));
        }
        boolean to = StringUtils.isBlank((String)smtp.getTo());
        boolean cc = StringUtils.isBlank((String)smtp.getCc());
        boolean bcc = StringUtils.isBlank((String)smtp.getBcc());
        if (!(to || cc || bcc)) {
            errors.configuration(RB.$((String)"validation_mail_not_blank", (Object[])new Object[]{"mail.to, mail.cc,", "mail.bcc"}));
        }
        if (StringUtils.isBlank((String)smtp.getSubject())) {
            smtp.setSubject(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (null == smtp.getMimeType()) {
            smtp.setMimeType(Mail.MimeType.TEXT);
        }
        if (StringUtils.isBlank((String)smtp.getMessage()) && StringUtils.isBlank((String)smtp.getMessageTemplate())) {
            smtp.setMessageTemplate("src/jreleaser/templates/mail.tpl");
        }
        if (StringUtils.isNotBlank((String)smtp.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(smtp.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mail.messageTemplate", smtp.getMessageTemplate()}));
        }
    }
}

