/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.download.AbstractDownloader;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class HttpDownloader
extends AbstractDownloader<org.jreleaser.model.api.download.HttpDownloader, HttpDownloader>
implements Http {
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String username;
    private String password;
    private Http.Authorization authorization;
    private final org.jreleaser.model.api.download.HttpDownloader immutable = new org.jreleaser.model.api.download.HttpDownloader(){
        private List<? extends Downloader.Asset> assets;

        public String getUsername() {
            return HttpDownloader.this.username;
        }

        public String getPassword() {
            return HttpDownloader.this.password;
        }

        public Http.Authorization getAuthorization() {
            return HttpDownloader.this.authorization;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(HttpDownloader.this.getHeaders());
        }

        public String getType() {
            return HttpDownloader.this.type;
        }

        public String getName() {
            return HttpDownloader.this.name;
        }

        public List<? extends Downloader.Asset> getAssets() {
            if (null == this.assets) {
                this.assets = HttpDownloader.this.assets.stream().map(Downloader.Asset::asImmutable).collect(Collectors.toList());
            }
            return this.assets;
        }

        public Active getActive() {
            return HttpDownloader.this.active;
        }

        public boolean isEnabled() {
            return HttpDownloader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpDownloader.this.asMap(full));
        }

        public String getPrefix() {
            return HttpDownloader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpDownloader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return HttpDownloader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return HttpDownloader.this.readTimeout;
        }
    };

    public HttpDownloader() {
        super("http");
    }

    @Override
    public org.jreleaser.model.api.download.HttpDownloader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpDownloader source) {
        super.merge(source);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.authorization = this.merge(this.authorization, source.authorization);
        this.setHeaders(this.merge(this.headers, source.headers));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("authorization", this.authorization);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("headers", this.headers);
    }

    public String getResolvedUsername() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.NONE;
        }
        return this.authorization;
    }
}

