/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.ServiceLoader;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserModel;

public class JReleaserConfigLoader {
    public static JReleaserModel loadConfig(Path configFile) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            JReleaserModel jReleaserModel;
            block11: {
                if (!parser.supports(configFile)) continue;
                try {
                    parser.validate(configFile);
                }
                catch (IOException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_invalid_config_file", (Object[])new Object[]{configFile}), (Throwable)e);
                }
                InputStream inputStream = configFile.toUri().toURL().openStream();
                try {
                    jReleaserModel = parser.parse(inputStream);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new JReleaserException(RB.$((String)"ERROR_parsing_config_file", (Object[])new Object[]{configFile}), (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return jReleaserModel;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_config_format", (Object[])new Object[]{configFile}));
    }

    public static Map<String, String> loadProperties(Path file) throws IOException {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            if (!parser.supports(file)) continue;
            try (InputStream inputStream = file.toUri().toURL().openStream();){
                Map<String, String> map = parser.properties(inputStream);
                return map;
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_config_format", (Object[])new Object[]{file}));
    }

    public static <T> T load(Class<T> type, String resource, InputStream inputStream) throws IOException {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            if (!parser.supports(resource)) continue;
            try {
                return parser.load(type, inputStream);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_load_resource", (Object[])new Object[]{resource}), (Throwable)e);
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_config_format", (Object[])new Object[]{resource}));
    }
}

