/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.GiteaUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GiteaUploaderValidator
extends Validator {
    public static void validateGiteaUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GiteaUploader> gitea = context.getModel().getUpload().getGitea();
        if (!gitea.isEmpty()) {
            context.getLogger().debug("upload.gitea");
        }
        for (Map.Entry<String, GiteaUploader> e : gitea.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            GiteaUploaderValidator.validateGiteaUploader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateGiteaUploader(JReleaserContext context, JReleaserContext.Mode mode, GiteaUploader gitea, Errors errors) {
        context.getLogger().debug("upload.gitea.{}", new Object[]{gitea.getName()});
        if (!gitea.isActiveSet()) {
            gitea.setActive(Active.NEVER);
        }
        if (!gitea.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(gitea.isArtifacts() || gitea.isFiles() || gitea.isSignatures())) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            gitea.disable();
            return;
        }
        gitea.setToken(GiteaUploaderValidator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"GITEA_" + Env.toVar((String)gitea.getName()) + "_TOKEN", "GITEA_TOKEN"}), "gitea.token", gitea.getToken(), errors, context.isDryrun()));
        gitea.setHost(GiteaUploaderValidator.checkProperty(context, "GITEA_" + Env.toVar((String)gitea.getName()) + "_HOST", "gitea.host", gitea.getHost(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)gitea.getPackageName())) {
            gitea.setPackageName(gitea.getName());
        }
        if (StringUtils.isBlank((String)gitea.getPackageVersion())) {
            gitea.setPackageVersion("{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)gitea.getOwner())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"gitea." + gitea.getName() + ".owner"}));
        }
        GiteaUploaderValidator.validateTimeout(gitea);
    }
}

