/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.hooks.Hook;

public abstract class AbstractHook<S extends AbstractHook<S>>
extends AbstractModelObject<S>
implements Hook {
    protected final Hook.Filter filter = new Hook.Filter();
    protected Boolean continueOnError;
    protected Active active;
    @JsonIgnore
    protected boolean enabled;

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractHook)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractHook)source).enabled);
        this.continueOnError = this.merge(this.continueOnError, ((AbstractHook)source).continueOnError);
        this.setFilter(((AbstractHook)source).filter);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        map.put("continueOnError", this.isContinueOnError());
        Map<String, Object> filterAsMap = this.filter.asMap(full);
        if (full || !filterAsMap.isEmpty()) {
            map.put("filter", filterAsMap);
        }
        this.asMap(full, map);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

