/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class HttpAnnouncer
extends AbstractAnnouncer<HttpAnnouncer, org.jreleaser.model.api.announce.HttpAnnouncer>
implements Http {
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String url;
    private String username;
    private String password;
    private Http.Authorization authorization;
    private Http.Method method;
    private String payload;
    private String payloadTemplate;
    private String bearerKeyword;
    private final org.jreleaser.model.api.announce.HttpAnnouncer immutable = new org.jreleaser.model.api.announce.HttpAnnouncer(){

        public String getType() {
            return "http";
        }

        public Http.Method getMethod() {
            return null;
        }

        public String getUrl() {
            return HttpAnnouncer.this.url;
        }

        public String getPayload() {
            return HttpAnnouncer.this.payload;
        }

        public String getPayloadTemplate() {
            return HttpAnnouncer.this.payloadTemplate;
        }

        public String getUsername() {
            return HttpAnnouncer.this.username;
        }

        public String getPassword() {
            return HttpAnnouncer.this.password;
        }

        public Http.Authorization getAuthorization() {
            return HttpAnnouncer.this.authorization;
        }

        public String getBearerKeyword() {
            return HttpAnnouncer.this.getBearerKeyword();
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(HttpAnnouncer.this.headers);
        }

        public String getName() {
            return HttpAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return HttpAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return HttpAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return HttpAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return HttpAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return HttpAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return HttpAnnouncer.this.readTimeout;
        }
    };

    public HttpAnnouncer() {
        super("");
    }

    @Override
    public org.jreleaser.model.api.announce.HttpAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpAnnouncer source) {
        super.merge(source);
        this.url = this.merge(this.url, source.url);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.authorization = this.merge(this.authorization, source.authorization);
        this.bearerKeyword = this.merge(this.bearerKeyword, source.bearerKeyword);
        this.method = this.merge(this.method, source.method);
        this.payload = this.merge(this.payload, source.payload);
        this.payloadTemplate = this.merge(this.payloadTemplate, source.payloadTemplate);
        this.setHeaders(this.merge(this.headers, source.headers));
    }

    @Override
    public String getPrefix() {
        return "http";
    }

    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.NONE;
        }
        return this.authorization;
    }

    public String getResolvedUsername() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public String getResolvedUrl(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.url, props);
    }

    public String getResolvedPayload(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.payload, props);
    }

    public String getResolvedPayloadTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.payloadTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    public String getBearerKeyword() {
        return this.bearerKeyword;
    }

    public void setBearerKeyword(String bearerKeyword) {
        this.bearerKeyword = bearerKeyword;
    }

    public Http.Method getMethod() {
        return this.method;
    }

    public void setMethod(Http.Method method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = Http.Method.of((String)method);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayloadTemplate() {
        return this.payloadTemplate;
    }

    public void setPayloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("url", this.url);
        props.put("authorization", this.authorization);
        props.put("bearerKeyword", this.bearerKeyword);
        props.put("method", this.method);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("headers", this.headers);
        props.put("payload", this.payload);
        props.put("payloadTemplate", this.payloadTemplate);
    }
}

