/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jreleaser.cli.AbstractLoggingCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.TemplateGenerationException;
import org.jreleaser.templates.TemplateGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="template")
public class Template
extends AbstractLoggingCommand {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    Composite composite;
    @CommandLine.Option(names={"-o", "--overwrite"})
    boolean overwrite;
    @CommandLine.Option(names={"-sn", "--snapshot"})
    boolean snapshot;
    @CommandLine.ParentCommand
    Main parent;

    @Override
    protected Main parent() {
        return this.parent;
    }

    @Override
    protected void execute() {
        try {
            this.basedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
            this.initLogger();
            Path outputDirectory = this.basedir.resolve("src").resolve("jreleaser");
            Path output = TemplateGenerator.builder().logger(this.logger).distributionName(this.composite.distributionName()).distributionType(this.composite.distributionType()).packagerName(this.composite.packagerName()).announcerName(this.composite.announcerName()).outputDirectory(outputDirectory).overwrite(this.overwrite).snapshot(this.snapshot).build().generate();
            if (null != output && !this.quiet) {
                this.logger.info(this.$("jreleaser.template.TEXT_success", new Object[0]), new Object[]{output.toAbsolutePath()});
            }
        }
        catch (TemplateGenerationException e) {
            throw new JReleaserException(this.$("ERROR_unexpected_error", new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected Path getOutputDirectory() {
        if (null != this.outputdir) {
            return this.outputdir.resolve("jreleaser");
        }
        return this.basedir.resolve("out").resolve("jreleaser");
    }

    static class Packagers {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>", required=true)
        String distributionName;
        @CommandLine.Option(names={"-p", "--packager"}, paramLabel="<packager>", required=true)
        String packagerName;
        @CommandLine.Option(names={"-dt", "--distribution-type"}, paramLabel="<type>", required=true, defaultValue="JAVA_BINARY")
        Distribution.DistributionType distributionType;

        Packagers() {
        }
    }

    static class Announcers {
        @CommandLine.Option(names={"-a", "--announcer"}, paramLabel="<announcer>", descriptionKey="announcer.name", required=true)
        String announcerName;

        Announcers() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="announcer.header")
        Announcers announcers;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="packager.header")
        Packagers packagers;

        Composite() {
        }

        String announcerName() {
            return this.announcers != null ? this.announcers.announcerName : null;
        }

        String packagerName() {
            return this.packagers != null ? this.packagers.packagerName : null;
        }

        String distributionName() {
            return this.packagers != null ? this.packagers.distributionName : null;
        }

        Distribution.DistributionType distributionType() {
            return this.packagers != null ? this.packagers.distributionType : null;
        }
    }
}

