/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.direct.DirectConnection;

public abstract class SocketClient {
    private final int defaultPort;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private static final int DEFAULT_CONNECT_TIMEOUT = 0;
    private int connectTimeout = 0;
    private int timeout = 0;
    private String hostname;
    private int port;
    private boolean tunneled = false;

    SocketClient(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    protected InetSocketAddress makeInetSocketAddress(String hostname, int port) {
        return new InetSocketAddress(hostname, port);
    }

    public void connect(String hostname) throws IOException {
        this.connect(hostname, this.defaultPort);
    }

    public void connect(String hostname, int port) throws IOException {
        if (hostname == null) {
            this.connect(InetAddress.getByName(null), port);
        } else {
            this.hostname = hostname;
            this.port = port;
            this.socket = this.socketFactory.createSocket();
            this.socket.connect(this.makeInetSocketAddress(hostname, port), this.connectTimeout);
            this.onConnect();
        }
    }

    public void connect(String hostname, int port, InetAddress localAddr, int localPort) throws IOException {
        if (hostname == null) {
            this.connect(InetAddress.getByName(null), port, localAddr, localPort);
        } else {
            this.hostname = hostname;
            this.port = port;
            this.socket = this.socketFactory.createSocket();
            this.socket.bind(new InetSocketAddress(localAddr, localPort));
            this.socket.connect(this.makeInetSocketAddress(hostname, port), this.connectTimeout);
            this.onConnect();
        }
    }

    public void connectVia(Channel channel, String hostname, int port) throws IOException {
        this.hostname = hostname;
        this.port = port;
        this.input = channel.getInputStream();
        this.output = channel.getOutputStream();
        this.tunneled = true;
        this.onConnect();
    }

    public void connectVia(DirectConnection directConnection) throws IOException {
        this.connectVia(directConnection, directConnection.getRemoteHost(), directConnection.getRemotePort());
    }

    public void connect(InetAddress host) throws IOException {
        this.connect(host, this.defaultPort);
    }

    public void connect(InetAddress host, int port) throws IOException {
        this.port = port;
        this.socket = this.socketFactory.createSocket();
        this.socket.connect(new InetSocketAddress(host, port), this.connectTimeout);
        this.onConnect();
    }

    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws IOException {
        this.port = port;
        this.socket = this.socketFactory.createSocket();
        this.socket.bind(new InetSocketAddress(localAddr, localPort));
        this.socket.connect(new InetSocketAddress(host, port), this.connectTimeout);
        this.onConnect();
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    public boolean isConnected() {
        return this.tunneled || this.socket != null && this.socket.isConnected();
    }

    public int getLocalPort() {
        return this.tunneled ? 65536 : this.socket.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket == null ? null : this.socket.getLocalAddress();
    }

    public String getRemoteHostname() {
        return this.hostname == null ? (this.hostname = this.getRemoteAddress().getHostName()) : this.hostname;
    }

    public int getRemotePort() {
        return this.socket == null ? this.port : this.socket.getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket == null ? null : this.socket.getInetAddress();
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory == null ? SocketFactory.getDefault() : factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Socket getSocket() {
        return this.socket;
    }

    InputStream getInputStream() {
        return this.input;
    }

    OutputStream getOutputStream() {
        return this.output;
    }

    void onConnect() throws IOException {
        if (this.socket != null) {
            this.socket.setSoTimeout(this.timeout);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
    }
}

