/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.AppImage;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Github;
import org.jreleaser.model.Icon;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class AppImagePackagerProcessor
extends AbstractRepositoryPackagerProcessor<AppImage> {
    public AppImagePackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.setupPrepare(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    private void setupPrepare(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        try {
            props.put("appImageReleases", Releasers.releaserFor((JReleaserContext)this.context).listReleases(gitService.getOwner(), gitService.getName()).stream().map(r -> Release.of(r.getUrl(), r.getVersion().toString(), r.getPublishedAt())).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        props.put("appImageScreenshots", ((AppImage)this.packager).getScreenshots().stream().map(Screenshot::asScreenshotTemplate).collect(Collectors.toList()));
        this.context.getLogger().debug(RB.$((String)"packager.fetch.icons", (Object[])new Object[0]));
        props.put("appImageIcons", ((AppImage)this.packager).getIcons());
        for (Icon icon : ((AppImage)this.packager).getIcons()) {
            String iconUrl = Templates.resolveTemplate((String)icon.getUrl(), props);
            String iconExt = StringUtils.getFilenameExtension((String)iconUrl);
            Path iconPath = Paths.get(((AppImage)this.packager).getTemplateDirectory(), "icons", icon.getWidth() + "x" + icon.getHeight(), distribution.getExecutable().getName() + "." + iconExt);
            iconPath = this.context.getBasedir().resolve(iconPath);
            if (Files.exists(iconPath, new LinkOption[0])) continue;
            this.context.getLogger().debug("{} -> {}", new Object[]{iconUrl, this.context.relativizeToBasedir(iconPath)});
            try {
                FileUtils.copyURLToFile((URL)new URL(iconUrl), (File)iconPath.toFile(), (int)20000, (int)60000);
            }
            catch (IOException e) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{iconUrl}), (Throwable)e);
            }
        }
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        props.put("projectAuthors", this.context.getModel().getProject().getAuthors());
        props.put("appImageUrls", this.context.getModel().getProject().getLinks().asLinkTemplates());
        props.put("appImageComponentId", ((AppImage)this.getPackager()).getComponentId());
        props.put("appImageCategories", ((AppImage)this.getPackager()).getCategories());
        props.put("appImageCategoriesByComma", String.join((CharSequence)",", ((AppImage)this.getPackager()).getCategories()));
        props.put("appImageDeveloperName", ((AppImage)this.getPackager()).getDeveloperName());
        props.put("appImageRequiresTerminal", ((AppImage)this.getPackager()).isRequiresTerminal());
        props.put("appImageRepoOwner", ((AppImage)this.packager).getRepository().getOwner());
        props.put("appImageRepoName", ((AppImage)this.packager).getRepository().getName());
        GitService gitService = this.context.getModel().getRelease().getGitService();
        String str = (String)props.get("distributionArtifactFile");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "${DISTRIBUTION_VERSION}");
        props.put("appImageDistributionArtifactFile", str);
        str = (String)props.get("distributionArtifactFileName");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "${DISTRIBUTION_VERSION}");
        props.put("appImageDistributionArtifactFileName", str);
        str = (String)props.get("distributionUrl");
        str = str.replace(gitService.getEffectiveTagName(this.context.getModel()), "${DISTRIBUTION_TAG}").replace((String)props.get("distributionArtifactFile"), "${DISTRIBUTION_FILE}");
        props.put("appImageDistributionUrl", str);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Optional<Stereotype> stereotype;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (fileName.contains("github") && !(gitService instanceof Github)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = org.apache.commons.lang3.StringUtils.remove((String)fileName, (String)"-github");
        }
        if ((stereotype = this.resolveStereotype(fileName = TemplateUtils.trimTplExtension((String)fileName))).isPresent()) {
            if (distribution.getStereotype() == stereotype.get()) {
                fileName = fileName.substring(distribution.getStereotype().toString().length() + 1);
            } else {
                return;
            }
        }
        Path outputFile = outputDirectory.resolve(fileName);
        switch (fileName) {
            case "app.desktop": {
                outputFile = outputDirectory.resolve(distribution.getExecutable().getName() + ".desktop");
                break;
            }
            case "appdata.xml": {
                outputFile = outputDirectory.resolve(((AppImage)this.getPackager()).getComponentId() + ".appdata.xml");
            }
        }
        this.writeFile(content, outputFile);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, InputStream inputStream, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = outputDirectory.resolve(fileName);
        if (fileName.endsWith("app.png")) {
            outputFile = outputDirectory.resolve(fileName.replace("app", distribution.getExecutable().getName()));
        }
        this.writeFile(inputStream, outputFile);
    }

    private Optional<Stereotype> resolveStereotype(String fileName) {
        for (Stereotype stereotype : ((AppImage)this.packager).getSupportedStereotypes()) {
            if (!fileName.startsWith(stereotype.toString() + "-")) continue;
            return Optional.of(stereotype);
        }
        return Optional.empty();
    }

    public static class Release {
        private final String url;
        private final String version;
        private final String date;

        private Release(String url, String version, String date) {
            this.url = url;
            this.version = version;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDate() {
            return this.date;
        }

        public static Release of(String url, String version, Date date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return new Release(url, version, format.format(date));
        }
    }
}

