/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.TemplatePackager;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractPackagerProcessor;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractTemplatePackagerProcessor<T extends TemplatePackager>
extends AbstractPackagerProcessor<T> {
    protected AbstractTemplatePackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        try {
            this.doPrepareDistribution(distribution, props, distribution.getName(), this.getPrepareDirectory(props), ((TemplatePackager)this.getPackager()).getTemplateDirectory(), this.getPackagerName(), true);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        FileUtils.deleteFiles((Path)prepareDirectory);
        Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        this.context.getLogger().debug(RB.$((String)"packager.resolve.templates", (Object[])new Object[0]), new Object[]{distributionName, packagerName});
        Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)distribution.getType().name(), (String)this.getPackagerName(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(templateDirectory));
        for (Map.Entry entry : templates.entrySet()) {
            String filename = (String)entry.getKey();
            if (this.isSkipped(filename)) {
                this.context.getLogger().debug(RB.$((String)"packager.skipped.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                continue;
            }
            TemplateResource value = (TemplateResource)entry.getValue();
            if (value.isReader()) {
                this.context.getLogger().debug(RB.$((String)"packager.evaluate.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                String content = MustacheUtils.applyTemplate((Reader)value.getReader(), props);
                if (!content.endsWith(System.lineSeparator())) {
                    content = content + System.lineSeparator();
                }
                this.context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                this.writeFile(this.context.getModel().getProject(), distribution, content, props, prepareDirectory, filename);
                continue;
            }
            this.context.getLogger().debug(RB.$((String)"packager.write.file", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
            this.writeFile(this.context.getModel().getProject(), distribution, value.getInputStream(), props, prepareDirectory, filename);
        }
        if (copyLicense) {
            this.context.getLogger().debug(RB.$((String)"packager.copy.license", (Object[])new Object[0]));
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)prepareDirectory, path -> path.getFileName().startsWith("LICENSE"));
        }
    }

    public boolean isSkipped(String filename) {
        if (((TemplatePackager)this.packager).getSkipTemplates().contains(filename)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(filename::contains)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(filename::matches)) {
            return true;
        }
        String fname = TemplateUtils.trimTplExtension((String)filename);
        if (((TemplatePackager)this.packager).getSkipTemplates().contains(fname)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(fname::contains)) {
            return true;
        }
        return ((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(fname::matches);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.doPackageDistribution(distribution, props, this.getPackageDirectory(props));
    }

    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        try {
            FileUtils.deleteFiles((Path)packageDirectory);
            Files.createDirectories(packageDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected abstract void writeFile(Project var1, Distribution var2, String var3, Map<String, Object> var4, Path var5, String var6) throws PackagerProcessingException;

    protected void writeFile(Project project, Distribution distribution, InputStream inputStream, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(inputStream, outputFile);
    }

    protected void writeFile(Project project, Distribution distribution, Reader reader, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        this.writeFile(reader, outputDirectory.resolve(fileName));
    }

    protected void writeFile(Reader reader, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, IOUtils.toByteArray((Reader)reader, (Charset)StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(InputStream inputStream, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, IOUtils.toByteArray((InputStream)inputStream), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(byte[] content, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(String content, Path outputFile) throws PackagerProcessingException {
        this.writeFile(content.getBytes(), outputFile);
    }
}

