/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.form.FormData;
import java.util.List;
import java.util.Map;
import org.jreleaser.sdk.gitea.api.GtAsset;
import org.jreleaser.sdk.gitea.api.GtAttachment;
import org.jreleaser.sdk.gitea.api.GtBranch;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtOrganization;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.sdk.gitea.api.GtSearchUser;
import org.jreleaser.sdk.gitea.internal.Page;

public interface GiteaAPI {
    @RequestLine(value="GET /repos/{owner}/{repo}")
    public GtRepository getRepository(@Param(value="owner") String var1, @Param(value="repo") String var2);

    @RequestLine(value="GET /orgs/{org}")
    public GtOrganization getOrganization(@Param(value="org") String var1);

    @RequestLine(value="POST /orgs/{org}/repos")
    @Headers(value={"Content-Type: application/json"})
    public GtRepository createRepository(Map<String, Object> var1, @Param(value="org") String var2);

    @RequestLine(value="POST /user/repos")
    @Headers(value={"Content-Type: application/json"})
    public GtRepository createRepository(Map<String, Object> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/tags/{tag}")
    public GtRelease getReleaseByTagName(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/{id}")
    public void deleteRelease(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Integer var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/tags/{tag}")
    public void deleteTag(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public GtRelease createRelease(GtRelease var1, @Param(value="owner") String var2, @Param(value="repo") String var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/releases/{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRelease(GtRelease var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="id") Integer var4);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases/{id}/assets")
    @Headers(value={"Content-Type: multipart/form-data"})
    public GtAttachment uploadAsset(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Integer var3, @Param(value="attachment") FormData var4);

    @RequestLine(value="GET /repos/{owner}/{repo}/milestones/{milestoneName}")
    public GtMilestone findMilestoneByTitle(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="milestoneName") String var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/milestones/{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateMilestone(Map<String, Object> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="id") Integer var4);

    @RequestLine(value="GET /users/search")
    @Headers(value={"Content-Type: application/json"})
    public GtSearchUser searchUser(@QueryMap Map<String, String> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GtRelease>> listReleases(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/branches")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GtBranch>> listBranches(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/{releaseId}/assets")
    @Headers(value={"Content-Type: application/json"})
    public List<GtAsset> listAssets(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="releaseId") Integer var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/{releaseId}/assets/{assetId}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteAsset(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="releaseId") Integer var3, @Param(value="assetId") Integer var4);
}

