/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Upload;
import org.jreleaser.model.validation.ArtifactoryValidator;
import org.jreleaser.model.validation.FtpUploaderValidator;
import org.jreleaser.model.validation.GiteaUploaderValidator;
import org.jreleaser.model.validation.GitlabUploaderValidator;
import org.jreleaser.model.validation.HttpUploaderValidator;
import org.jreleaser.model.validation.S3Validator;
import org.jreleaser.model.validation.ScpUploaderValidator;
import org.jreleaser.model.validation.SftpUploaderValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class UploadersValidator
extends Validator {
    public static void validateUploaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Upload upload = context.getModel().getUpload();
        context.getLogger().debug("upload");
        boolean skipValidation = !mode.validateConfig();
        Errors errorCollector = skipValidation ? new Errors() : errors;
        ArtifactoryValidator.validateArtifactory(context, mode, errorCollector);
        FtpUploaderValidator.validateFtpUploader(context, mode, errorCollector);
        GiteaUploaderValidator.validateGiteaUploader(context, mode, errorCollector);
        GitlabUploaderValidator.validateGitlabUploader(context, mode, errorCollector);
        HttpUploaderValidator.validateHttpUploader(context, mode, errorCollector);
        S3Validator.validateS3(context, mode, errorCollector);
        ScpUploaderValidator.validateScpUploader(context, mode, errorCollector);
        SftpUploaderValidator.validateSftpUploader(context, mode, errorCollector);
        if (skipValidation) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        boolean activeSet = upload.isActiveSet();
        upload.resolveEnabled(context.getModel().getProject());
        if (mode.validateConfig() && upload.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = !upload.getActiveArtifactories().isEmpty() || !upload.getActiveFtps().isEmpty() || !upload.getActiveGiteas().isEmpty() || !upload.getActiveGitlabs().isEmpty() || !upload.getActiveHttps().isEmpty() || !upload.getActiveS3s().isEmpty() || !upload.getActiveScps().isEmpty() || !upload.getActiveSftps().isEmpty();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                upload.disable();
            }
        }
    }
}

