/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Docker;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.TemplatePackager;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TemplateValidator
extends Validator {
    public static void validateTemplate(JReleaserContext context, Distribution distribution, TemplatePackager packager, TemplatePackager parentPackager, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/distributions/" + distribution.getName() + "/" + packager.getType();
        if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
            packager.setTemplateDirectory(parentPackager.getTemplateDirectory());
            if (StringUtils.isNotBlank((String)packager.getTemplateDirectory()) && !defaultTemplateDirectory.equals(packager.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(packager.getTemplateDirectory().trim()), new LinkOption[0])) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + packager.getType() + ".template", packager.getTemplateDirectory()}));
            }
            if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
                packager.setTemplateDirectory(defaultTemplateDirectory);
            }
            return;
        }
        if (StringUtils.isNotBlank((String)packager.getTemplateDirectory()) && !defaultTemplateDirectory.equals(packager.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(packager.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + packager.getType() + ".template", packager.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
            packager.setTemplateDirectory(defaultTemplateDirectory);
        }
    }

    public static void validateTemplate(JReleaserContext context, JavaAssembler assembler, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/assemblers/" + assembler.getName() + "/" + assembler.getType();
        if (StringUtils.isNotBlank((String)assembler.getTemplateDirectory()) && !defaultTemplateDirectory.equals(assembler.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(assembler.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".template", assembler.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)assembler.getTemplateDirectory())) {
            assembler.setTemplateDirectory(defaultTemplateDirectory);
        }
    }

    public static void validateTemplate(JReleaserContext context, Distribution distribution, DockerSpec spec, Docker docker, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/distributions/" + distribution.getName() + "/" + docker.getType() + "/" + spec.getName();
        if (StringUtils.isNotBlank((String)spec.getTemplateDirectory()) && !defaultTemplateDirectory.equals(spec.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(spec.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".docker." + spec.getName() + ".template", spec.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)spec.getTemplateDirectory())) {
            spec.setTemplateDirectory(defaultTemplateDirectory);
        }
    }
}

