/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Brew;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class BrewValidator
extends Validator {
    public static void validateBrew(JReleaserContext context, Distribution distribution, Brew packager, Errors errors) {
        context.getLogger().debug("distribution.{}.brew", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        Brew parentPackager = model.getPackagers().getBrew();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            packager.disable();
            packager.getCask().disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            packager.getCask().disable();
            return;
        }
        Brew.Cask cask = BrewValidator.preValidateCask(distribution, packager, parentPackager);
        if (!packager.isMultiPlatformSet() && parentPackager.isMultiPlatformSet()) {
            packager.setMultiPlatform(parentPackager.isMultiPlatform());
        }
        if (packager.isMultiPlatform() && (distribution.getType() == Distribution.DistributionType.SINGLE_JAR || distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE)) {
            packager.setMultiPlatform(false);
        }
        if (packager.isMultiPlatform()) {
            packager.getCask().disable();
        }
        BrewValidator.validateCask(context, distribution, packager, cask, errors);
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        BrewValidator.validateCommitAuthor(packager, parentPackager);
        Brew.HomebrewTap tap = packager.getTap();
        tap.resolveEnabled(model.getProject());
        BrewValidator.validateTap(context, distribution, tap, parentPackager.getTap(), "brew.tap");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        BrewValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        ArrayList<Brew.Dependency> dependencies = new ArrayList<Brew.Dependency>(parentPackager.getDependenciesAsList());
        dependencies.addAll(packager.getDependenciesAsList());
        packager.setDependenciesAsList(dependencies);
        if (StringUtils.isBlank((String)packager.getFormulaName())) {
            packager.setFormulaName(distribution.getName());
        }
        if (!cask.isEnabled()) {
            DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        }
    }

    private static Brew.Cask preValidateCask(Distribution distribution, Brew packager, Brew parentPackager) {
        Brew.Cask cask = packager.getCask();
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            packager.getCask().disable();
            return cask;
        }
        Brew.Cask parentCask = parentPackager.getCask();
        if (!cask.isEnabledSet() && parentCask.isEnabledSet()) {
            cask.setEnabled(parentCask.isEnabled());
        }
        return cask;
    }

    private static void validateCask(JReleaserContext context, Distribution distribution, Brew packager, Brew.Cask cask, Errors errors) {
        if (cask == null || cask.isEnabledSet() && !cask.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.brew.cask", new Object[]{distribution.getName()});
        int dmgFound = 0;
        int pkgFound = 0;
        int zipFound = 0;
        String pkgName = "";
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.isActive() || !PlatformUtils.isMac((String)artifact.getPlatform())) continue;
            if (artifact.getPath().endsWith(".dmg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++dmgFound;
                continue;
            }
            if (artifact.getPath().endsWith(".pkg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++pkgFound;
                pkgName = artifact.getEffectivePath(context).getFileName().toString();
                continue;
            }
            if (!artifact.getPath().endsWith(".zip") || StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) continue;
            ++zipFound;
        }
        if (dmgFound == 0 && pkgFound == 0 && zipFound == 0) {
            cask.disable();
            return;
        }
        if (dmgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".dmg"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (pkgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".pkg"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".zip"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (dmgFound + pkgFound + zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_single_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (zipFound == 1 && !cask.isEnabled()) {
            return;
        }
        cask.enable();
        if (StringUtils.isBlank((String)cask.getPkgName()) && StringUtils.isNotBlank((String)pkgName)) {
            cask.setPkgName(pkgName);
        }
        if (StringUtils.isNotBlank((String)cask.getPkgName())) {
            if (!cask.getPkgName().endsWith(".pkg")) {
                cask.setPkgName(cask.getPkgName() + ".pkg");
            }
        } else if (StringUtils.isBlank((String)cask.getAppName())) {
            cask.setAppName(packager.getResolvedFormulaName(context) + ".app");
        } else if (!cask.getAppName().endsWith(".app")) {
            cask.setAppName(cask.getAppName() + ".app");
        }
        if (zipFound > 0) {
            cask.setAppName("");
            cask.setPkgName("");
        }
        if (StringUtils.isBlank((String)cask.getName())) {
            cask.setName(packager.getResolvedFormulaName(context).toLowerCase(Locale.ENGLISH));
        }
        if (StringUtils.isBlank((String)cask.getDisplayName())) {
            cask.setDisplayName(packager.getResolvedFormulaName(context));
        }
    }

    public static void postValidateBrew(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getActiveDistributions().stream().filter(d -> d.getBrew().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getResolvedFormulaName(context)));
        map.forEach((formulaName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.formulaName '" + formulaName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
        map = context.getModel().getActiveDistributions().stream().filter(d -> d.getBrew().getCask().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getCask().getResolvedCaskName(context)));
        map.forEach((caskName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.cask.name '" + caskName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

