/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Announce;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.ArticleValidator;
import org.jreleaser.model.validation.DiscordValidator;
import org.jreleaser.model.validation.DiscussionsValidator;
import org.jreleaser.model.validation.GitterValidator;
import org.jreleaser.model.validation.GoogleChatValidator;
import org.jreleaser.model.validation.MailValidator;
import org.jreleaser.model.validation.MastodonValidator;
import org.jreleaser.model.validation.MattermostValidator;
import org.jreleaser.model.validation.SdkmanAnnouncerValidator;
import org.jreleaser.model.validation.SlackValidator;
import org.jreleaser.model.validation.TeamsValidator;
import org.jreleaser.model.validation.TelegramValidator;
import org.jreleaser.model.validation.TwitterValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.model.validation.WebhooksValidator;
import org.jreleaser.model.validation.ZulipValidator;
import org.jreleaser.util.Errors;

public abstract class AnnouncersValidator
extends Validator {
    public static void validateAnnouncers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Announce announce = context.getModel().getAnnounce();
        context.getLogger().debug("announce");
        boolean skipValidation = !mode.validateAnnounce() && !mode.validateConfig();
        Errors errorCollector = skipValidation ? new Errors() : errors;
        ArticleValidator.validateArticle(context, announce.getArticle(), errorCollector);
        DiscussionsValidator.validateDiscussions(context, announce.getDiscussions(), errorCollector);
        DiscordValidator.validateDiscord(context, announce.getDiscord(), errorCollector);
        GitterValidator.validateGitter(context, announce.getGitter(), errorCollector);
        GoogleChatValidator.validateGoogleChat(context, announce.getGoogleChat(), errorCollector);
        MailValidator.validateMail(context, announce.getMail(), errorCollector);
        MastodonValidator.validateMastodon(context, announce.getMastodon(), errorCollector);
        MattermostValidator.validateMattermost(context, announce.getMattermost(), errorCollector);
        SdkmanAnnouncerValidator.validateSdkmanAnnouncer(context, announce.getSdkman(), errorCollector);
        SlackValidator.validateSlack(context, announce.getSlack(), errorCollector);
        TeamsValidator.validateTeams(context, announce.getTeams(), errorCollector);
        TelegramValidator.validateTelegram(context, announce.getTelegram(), errorCollector);
        TwitterValidator.validateTwitter(context, announce.getTwitter(), errorCollector);
        WebhooksValidator.validateWebhooks(context, announce.getConfiguredWebhooks(), errorCollector);
        ZulipValidator.validateZulip(context, announce.getZulip(), errorCollector);
        if (skipValidation) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        boolean activeSet = announce.isActiveSet();
        announce.resolveEnabled(context.getModel().getProject());
        if (announce.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = announce.getArticle().isEnabled() || announce.getDiscord().isEnabled() || announce.getDiscussions().isEnabled() || announce.getGitter().isEnabled() || announce.getGoogleChat().isEnabled() || announce.getMail().isEnabled() || announce.getMastodon().isEnabled() || announce.getMattermost().isEnabled() || announce.getSdkman().isEnabled() || announce.getSlack().isEnabled() || announce.getTeams().isEnabled() || announce.getTelegram().isEnabled() || announce.getTwitter().isEnabled() || announce.getConfiguredWebhooks().isEnabled() || announce.getZulip().isEnabled();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                announce.disable();
            }
        }
    }
}

