/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Twitter
extends AbstractAnnouncer<Twitter> {
    public static final String NAME = "twitter";
    public static final String TWITTER_CONSUMER_KEY = "TWITTER_CONSUMER_KEY";
    public static final String TWITTER_CONSUMER_SECRET = "TWITTER_CONSUMER_SECRET";
    public static final String TWITTER_ACCESS_TOKEN = "TWITTER_ACCESS_TOKEN";
    public static final String TWITTER_ACCESS_TOKEN_SECRET = "TWITTER_ACCESS_TOKEN_SECRET";
    private final List<String> statuses = new ArrayList<String>();
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private String status;
    private String statusTemplate;

    public Twitter() {
        super(NAME);
    }

    @Override
    public void merge(Twitter twitter) {
        this.freezeCheck();
        super.merge(twitter);
        this.consumerKey = this.merge(this.consumerKey, twitter.consumerKey);
        this.consumerSecret = this.merge(this.consumerSecret, twitter.consumerSecret);
        this.accessToken = this.merge(this.accessToken, twitter.accessToken);
        this.accessTokenSecret = this.merge(this.accessTokenSecret, twitter.accessTokenSecret);
        this.status = this.merge(this.status, twitter.status);
        this.setStatuses(this.merge(this.statuses, twitter.statuses));
        this.statusTemplate = this.merge(this.statusTemplate, twitter.statusTemplate);
    }

    public String getResolvedStatus(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        context.getModel().getRelease().getGitService().fillProps(props, context.getModel());
        return Templates.resolveTemplate((String)this.status, props);
    }

    public String getResolvedStatusTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.statusTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedConsumerKey() {
        return Env.env((String)TWITTER_CONSUMER_KEY, (String)this.consumerKey);
    }

    public String getResolvedConsumerSecret() {
        return Env.env((String)TWITTER_CONSUMER_SECRET, (String)this.consumerSecret);
    }

    public String getResolvedAccessToken() {
        return Env.env((String)TWITTER_ACCESS_TOKEN, (String)this.accessToken);
    }

    public String getResolvedAccessTokenSecret() {
        return Env.env((String)TWITTER_ACCESS_TOKEN_SECRET, (String)this.accessTokenSecret);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.freezeCheck();
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.freezeCheck();
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.freezeCheck();
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.freezeCheck();
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.freezeCheck();
        this.status = status;
    }

    public List<String> getStatuses() {
        return this.freezeWrap(this.statuses);
    }

    public void setStatuses(List<String> statuses) {
        this.freezeCheck();
        this.statuses.clear();
        this.statuses.addAll(statuses);
    }

    public String getStatusTemplate() {
        return this.statusTemplate;
    }

    public void setStatusTemplate(String statusTemplate) {
        this.freezeCheck();
        this.statusTemplate = statusTemplate;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerSecret", StringUtils.isNotBlank((String)this.getResolvedConsumerSecret()) ? "************" : "**unset**");
        props.put("accessToken", StringUtils.isNotBlank((String)this.getResolvedAccessToken()) ? "************" : "**unset**");
        props.put("accessTokenSecret", StringUtils.isNotBlank((String)this.getResolvedAccessTokenSecret()) ? "************" : "**unset**");
        props.put("status", this.status);
        props.put("statuses", this.statuses);
        props.put("statusTemplate", this.statusTemplate);
    }
}

