/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Scoop
extends AbstractRepositoryPackager<Scoop> {
    public static final String TYPE = "scoop";
    public static final String SKIP_SCOOP = "skipScoop";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final ScoopBucket bucket = new ScoopBucket();
    private String packageName;
    private String checkverUrl;
    private String autoupdateUrl;

    public Scoop() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.bucket.freeze();
    }

    @Override
    public void merge(Scoop scoop) {
        this.freezeCheck();
        super.merge(scoop);
        this.packageName = this.merge(this.packageName, scoop.packageName);
        this.checkverUrl = this.merge(this.checkverUrl, scoop.checkverUrl);
        this.autoupdateUrl = this.merge(this.autoupdateUrl, scoop.autoupdateUrl);
        this.setBucket(scoop.bucket);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.freezeCheck();
        this.packageName = packageName;
    }

    public String getCheckverUrl() {
        return this.checkverUrl;
    }

    public void setCheckverUrl(String checkverUrl) {
        this.freezeCheck();
        this.checkverUrl = checkverUrl;
    }

    public String getAutoupdateUrl() {
        return this.autoupdateUrl;
    }

    public void setAutoupdateUrl(String autoupdateUrl) {
        this.freezeCheck();
        this.autoupdateUrl = autoupdateUrl;
    }

    public ScoopBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(ScoopBucket bucket) {
        this.bucket.merge(bucket);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("checkverUrl", this.checkverUrl);
        props.put("autoupdateUrl", this.autoupdateUrl);
        props.put("bucket", this.bucket.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.bucket;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_SCOOP));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.MSI.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
    }

    public static class ScoopBucket
    extends AbstractRepositoryTap<ScoopBucket> {
        public ScoopBucket() {
            super(Scoop.TYPE, Scoop.TYPE);
        }
    }
}

