/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Icon;
import org.jreleaser.model.ModelObject;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.Stereotype;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Flatpak
extends AbstractRepositoryPackager<Flatpak> {
    public static final String TYPE = "flatpak";
    public static final String SKIP_FLATPAK = "skipFlatpak";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final FlatpakRepository repository = new FlatpakRepository();
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<String> categories = new ArrayList<String>();
    private final List<Icon> icons = new ArrayList<Icon>();
    private final Set<String> sdkExtensions = new LinkedHashSet<String>();
    private final Set<String> finishArgs = new LinkedHashSet<String>();
    private String componentId;
    private String developerName;
    private Runtime runtime;
    private String runtimeVersion;

    public Flatpak() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.screenshots.forEach(ModelObject::freeze);
        this.icons.forEach(ModelObject::freeze);
    }

    @Override
    public void merge(Flatpak source) {
        this.freezeCheck();
        super.merge(source);
        this.componentId = this.merge(this.componentId, source.componentId);
        this.developerName = this.merge(this.developerName, source.developerName);
        this.runtime = this.merge(this.runtime, source.runtime);
        this.runtimeVersion = this.merge(this.runtimeVersion, source.runtimeVersion);
        this.setSdkExtensions(this.merge(this.sdkExtensions, source.sdkExtensions));
        this.setFinishArgs(this.merge(this.finishArgs, source.finishArgs));
        this.setRepository(source.repository);
        this.setCategories(this.merge(this.categories, source.categories));
        this.setScreenshots(this.merge(this.screenshots, source.screenshots));
        this.setIcons(this.merge(this.icons, source.icons));
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return CollectionUtils.setOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP});
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.freezeCheck();
        this.componentId = componentId;
    }

    public List<String> getCategories() {
        return this.freezeWrap(this.categories);
    }

    public void setCategories(List<String> tags) {
        this.freezeCheck();
        this.categories.clear();
        this.categories.addAll(tags);
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.freezeCheck();
        this.developerName = developerName;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.freezeCheck();
        this.runtime = runtime;
    }

    public void setRuntime(String runtime) {
        this.setRuntime(Runtime.of(runtime));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.freezeCheck();
        this.runtimeVersion = runtimeVersion;
    }

    public Set<String> getSdkExtensions() {
        return this.freezeWrap(this.sdkExtensions);
    }

    public void setSdkExtensions(Set<String> sdkExtensions) {
        this.freezeCheck();
        this.sdkExtensions.clear();
        this.sdkExtensions.addAll(sdkExtensions);
    }

    public Set<String> getFinishArgs() {
        return this.freezeWrap(this.finishArgs);
    }

    public void setFinishArgs(Set<String> finishArgs) {
        this.freezeCheck();
        this.finishArgs.clear();
        this.finishArgs.addAll(finishArgs);
    }

    public List<Screenshot> getScreenshots() {
        return this.freezeWrap(this.screenshots);
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.freezeCheck();
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        this.freezeCheck();
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<Icon> getIcons() {
        return this.freezeWrap(this.icons);
    }

    public void setIcons(List<Icon> icons) {
        this.freezeCheck();
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(Icon icon) {
        this.freezeCheck();
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public FlatpakRepository getRepository() {
        return this.repository;
    }

    public void setRepository(FlatpakRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> map) {
        super.asMap(full, map);
        map.put("componentId", this.componentId);
        map.put("categories", this.categories);
        map.put("developerName", this.developerName);
        map.put("runtime", (Object)this.runtime);
        map.put("runtimeVersion", this.runtimeVersion);
        map.put("sdkExtensions", this.sdkExtensions);
        map.put("finishArgs", this.finishArgs);
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        map.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        map.put("icons", sm);
        map.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_FLATPAK));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }

    public static class FlatpakRepository
    extends AbstractRepositoryTap<FlatpakRepository> {
        public FlatpakRepository() {
            super(Flatpak.TYPE, Flatpak.TYPE);
        }
    }

    public static enum Runtime {
        FREEDESKTOP("org.freedesktop.Platform", "org.freedesktop.Sdk"),
        GNOME("org.gnome.Platform", "org.gnome.Sdk"),
        KDE("org.kde.Platform", "org.kde.Sdk"),
        ELEMENTARY("io.elementary.Platform", "io.elementary.Sdk");

        private final String runtime;
        private final String sdk;

        private Runtime(String runtime, String sdk) {
            this.runtime = runtime;
            this.sdk = sdk;
        }

        public String runtime() {
            return this.runtime;
        }

        public String sdk() {
            return this.sdk;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Runtime of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Runtime.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

