/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.Java;
import org.jreleaser.model.Packager;
import org.jreleaser.model.Packagers;
import org.jreleaser.model.Platform;
import org.jreleaser.model.Project;
import org.jreleaser.model.Stereotype;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;

public class Distribution
extends Packagers<Distribution>
implements ExtraProperties,
Activatable {
    public static final EnumSet<DistributionType> JAVA_DISTRIBUTION_TYPES = EnumSet.of(DistributionType.JAVA_BINARY, DistributionType.JLINK, DistributionType.SINGLE_JAR);
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final Java java = new Java();
    private final Platform platform = new Platform();
    private final Executable executable = new Executable();
    private Active active;
    @JsonIgnore
    private boolean enabled;
    private String name;
    private DistributionType type = DistributionType.JAVA_BINARY;
    private Stereotype stereotype;

    @Override
    public void freeze() {
        super.freeze();
        this.artifacts.forEach(AbstractModelObject::freeze);
        this.java.freeze();
        this.platform.freeze();
        this.executable.freeze();
    }

    @Override
    public void merge(Distribution distribution) {
        this.freezeCheck();
        super.merge(distribution);
        this.active = this.merge(this.active, distribution.active);
        this.enabled = this.merge(this.enabled, distribution.enabled);
        this.name = this.merge(this.name, distribution.name);
        this.type = this.merge(this.type, distribution.type);
        this.stereotype = this.merge(this.stereotype, distribution.stereotype);
        this.setExecutable(distribution.executable);
        this.setPlatform(distribution.platform);
        this.setJava(distribution.java);
        this.setTags(this.merge(this.tags, distribution.tags));
        this.setExtraProperties(this.merge(this.extraProperties, distribution.extraProperties));
        this.setArtifacts(this.merge(this.artifacts, distribution.artifacts));
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        props.put("distributionStereotype", (Object)this.getStereotype());
        props.put("distributionExecutable", this.executable.getName());
        props.put("distributionExecutableName", this.executable.getName());
        props.put("distributionExecutableUnix", this.executable.resolveExecutable("linux"));
        props.put("distributionExecutableWindows", this.executable.resolveExecutable("windows"));
        CollectionUtils.safePut((String)"distributionExecutableExtensionUnix", (Object)this.executable.resolveUnixExtension(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionExecutableExtensionWindows", (Object)this.executable.resolveWindowsExtension(), props, (boolean)true);
        props.put("distributionTagsBySpace", String.join((CharSequence)" ", this.tags));
        props.put("distributionTagsByComma", String.join((CharSequence)",", this.tags));
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            SemVer jv = SemVer.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform.merge(platform);
    }

    @Override
    public String getPrefix() {
        return "distribution";
    }

    public DistributionType getType() {
        return this.type;
    }

    public void setType(DistributionType type) {
        this.freezeCheck();
        this.type = type;
    }

    public void setType(String type) {
        this.freezeCheck();
        this.type = DistributionType.of(type);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.freezeCheck();
        this.stereotype = stereotype;
    }

    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of(str));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable.merge(executable);
    }

    public Set<Artifact> getArtifacts() {
        return this.freezeWrap(Artifact.sortArtifacts(this.artifacts));
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.freezeCheck();
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<Artifact> artifacts) {
        this.freezeCheck();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(Artifact artifact) {
        this.freezeCheck();
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<String> getTags() {
        return this.freezeWrap(this.tags);
    }

    public void setTags(List<String> tags) {
        this.freezeCheck();
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(List<String> tags) {
        this.freezeCheck();
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.add(tag.trim());
        }
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.merge(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.extraProperties.containsKey(k)) {
                this.extraProperties.put((String)k, v);
            }
        });
    }

    public <T extends Packager> T findPackager(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_packager_name_not_blank", (Object[])new Object[0]));
        }
        return this.resolvePackager(name);
    }

    public <T extends Packager> T getPackager(String name) {
        T packager = this.findPackager(name);
        if (null != packager) {
            return packager;
        }
        throw new JReleaserException(RB.$((String)"ERROR_packager_not_configured", (Object[])new Object[]{name}));
    }

    private <T extends Packager> T resolvePackager(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "appimage": {
                return (T)this.getAppImage();
            }
            case "asdf": {
                return (T)this.getAsdf();
            }
            case "brew": {
                return (T)this.getBrew();
            }
            case "chocolatey": {
                return (T)this.getChocolatey();
            }
            case "docker": {
                return (T)this.getDocker();
            }
            case "flatpak": {
                return (T)this.getFlatpak();
            }
            case "gofish": {
                return (T)this.getGofish();
            }
            case "jbang": {
                return (T)this.getJbang();
            }
            case "macports": {
                return (T)this.getMacports();
            }
            case "scoop": {
                return (T)this.getScoop();
            }
            case "sdkman": {
                return (T)this.getSdkman();
            }
            case "snap": {
                return (T)this.getSnap();
            }
            case "spec": {
                return (T)this.getSpec();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{name}));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("type", (Object)this.type);
        props.put("executable", this.executable.asMap(full));
        if (full || this.platform.isSet()) {
            props.put("platform", this.platform.asMap(full));
        }
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        props.put("artifacts", mappedArtifacts);
        props.put("tags", this.tags);
        props.put("stereotype", (Object)this.stereotype);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
        props.putAll(super.asMap(full));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, props);
        return map;
    }

    public static Set<String> supportedPackagers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("appimage");
        set.add("asdf");
        set.add("brew");
        set.add("chocolatey");
        set.add("docker");
        set.add("flatpak");
        set.add("gofish");
        set.add("jbang");
        set.add("macports");
        set.add("scoop");
        set.add("sdkman");
        set.add("snap");
        set.add("spec");
        return Collections.unmodifiableSet(set);
    }

    public static class Executable
    extends AbstractModelObject<Executable>
    implements Domain {
        private String name;
        private String unixExtension;
        private String windowsExtension = "bat";

        @Override
        public void merge(Executable executable) {
            this.freezeCheck();
            this.name = this.merge(this.name, executable.name);
            this.unixExtension = this.merge(this.unixExtension, executable.unixExtension);
            this.windowsExtension = this.merge(this.windowsExtension, executable.windowsExtension);
        }

        public String resolveExecutable(String platform) {
            if (PlatformUtils.isWindows((String)platform)) {
                return this.name + this.resolveWindowsExtension();
            }
            return this.name + this.resolveUnixExtension();
        }

        public String resolveUnixExtension() {
            return StringUtils.isNotBlank((String)this.unixExtension) ? "." + this.unixExtension : "";
        }

        public String resolveWindowsExtension() {
            return "." + this.windowsExtension;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        public String getUnixExtension() {
            return this.unixExtension;
        }

        public void setUnixExtension(String unixExtension) {
            this.freezeCheck();
            this.unixExtension = unixExtension;
        }

        public String getWindowsExtension() {
            return this.windowsExtension;
        }

        public void setWindowsExtension(String windowsExtension) {
            this.freezeCheck();
            this.windowsExtension = windowsExtension;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("unixExtension", this.unixExtension);
            map.put("windowsExtension", this.windowsExtension);
            return map;
        }
    }

    public static enum DistributionType {
        BINARY("binary"),
        JAVA_BINARY("java"),
        JLINK("jlink"),
        SINGLE_JAR("uberjar"),
        NATIVE_IMAGE("graal"),
        NATIVE_PACKAGE("jpackage");

        private final String alias;

        private DistributionType(String alias) {
            this.alias = alias.toUpperCase(Locale.ENGLISH);
        }

        public static DistributionType of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            String value = str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase(Locale.ENGLISH).trim();
            for (DistributionType type : DistributionType.values()) {
                if (!type.alias.equals(value)) continue;
                return type;
            }
            return DistributionType.valueOf(value);
        }
    }
}

