/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.StringUtils;

public class Changelog
extends AbstractModelObject<Changelog>
implements Domain,
EnabledAware {
    private final Set<String> includeLabels = new LinkedHashSet<String>();
    private final Set<String> excludeLabels = new LinkedHashSet<String>();
    private final Set<Category> categories = new TreeSet<Category>(Category.ORDER);
    private final List<Replacer> replacers = new ArrayList<Replacer>();
    private final Set<Labeler> labelers = new TreeSet<Labeler>(Labeler.ORDER);
    private final Hide hide = new Hide();
    private final Contributors contributors = new Contributors();
    private Boolean enabled;
    private Boolean links;
    private Boolean skipMergeCommits;
    private Sort sort;
    private String external;
    private Active formatted;
    private String format;
    private String content;
    private String contentTemplate;
    private String preset;

    public boolean isSet() {
        return !this.includeLabels.isEmpty() || !this.excludeLabels.isEmpty() || !this.categories.isEmpty() || !this.replacers.isEmpty() || !this.labelers.isEmpty() || this.hide.isSet() || this.contributors.isSet() || null != this.links || null != this.skipMergeCommits || null != this.sort || null != this.formatted || StringUtils.isNotBlank((String)this.external) || StringUtils.isNotBlank((String)this.format) || StringUtils.isNotBlank((String)this.content) || StringUtils.isNotBlank((String)this.contentTemplate) || StringUtils.isNotBlank((String)this.preset);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.categories.forEach(AbstractModelObject::freeze);
        this.replacers.forEach(AbstractModelObject::freeze);
        this.labelers.forEach(AbstractModelObject::freeze);
        this.hide.freeze();
        this.contributors.freeze();
    }

    @Override
    public void merge(Changelog changelog) {
        this.freezeCheck();
        this.enabled = this.merge(this.enabled, changelog.enabled);
        this.links = this.merge(this.links, changelog.links);
        this.skipMergeCommits = this.merge(this.skipMergeCommits, changelog.skipMergeCommits);
        this.sort = this.merge(this.sort, changelog.sort);
        this.external = this.merge(this.external, changelog.external);
        this.formatted = this.merge(this.formatted, changelog.formatted);
        this.format = this.merge(this.format, changelog.format);
        this.content = this.merge(this.content, changelog.content);
        this.contentTemplate = this.merge(this.contentTemplate, changelog.contentTemplate);
        this.preset = this.merge(this.preset, changelog.preset);
        this.setIncludeLabels(this.merge(this.includeLabels, changelog.includeLabels));
        this.setExcludeLabels(this.merge(this.excludeLabels, changelog.excludeLabels));
        this.setCategories(this.merge(this.categories, changelog.categories));
        this.setReplacers(this.merge(this.replacers, changelog.replacers));
        this.setLabelers(this.merge(this.labelers, changelog.labelers));
        this.setHide(changelog.hide);
        this.setContributors(changelog.contributors);
    }

    public boolean resolveFormatted(Project project) {
        if (null == this.formatted) {
            this.formatted = Active.NEVER;
        }
        return this.formatted.check(project);
    }

    public Reader getResolvedContentTemplate(JReleaserContext context) {
        if (StringUtils.isNotBlank((String)this.content)) {
            return new StringReader(this.content);
        }
        Path templatePath = context.getBasedir().resolve(this.contentTemplate);
        try {
            return Files.newBufferedReader(templatePath);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.freezeCheck();
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public boolean isLinks() {
        return this.links != null && this.links != false;
    }

    public void setLinks(Boolean links) {
        this.freezeCheck();
        this.links = links;
    }

    public boolean isSkipMergeCommits() {
        return this.skipMergeCommits != null && this.skipMergeCommits != false;
    }

    public void setSkipMergeCommits(Boolean skipMergeCommits) {
        this.freezeCheck();
        this.skipMergeCommits = skipMergeCommits;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.freezeCheck();
        this.sort = sort;
    }

    public void setSort(String sort) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)sort)) {
            this.setSort(Sort.valueOf(sort.toUpperCase(Locale.ENGLISH)));
        }
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.freezeCheck();
        this.external = external;
    }

    public Active getFormatted() {
        return this.formatted;
    }

    public void setFormatted(Active formatted) {
        this.freezeCheck();
        this.formatted = formatted;
    }

    public void setFormatted(String str) {
        this.setFormatted(Active.of(str));
    }

    public boolean isFormattedSet() {
        return this.formatted != null;
    }

    public Set<String> getIncludeLabels() {
        return this.freezeWrap(this.includeLabels);
    }

    public void setIncludeLabels(Set<String> includeLabels) {
        this.freezeCheck();
        this.includeLabels.clear();
        this.includeLabels.addAll(includeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<String> getExcludeLabels() {
        return this.freezeWrap(this.excludeLabels);
    }

    public void setExcludeLabels(Set<String> excludeLabels) {
        this.freezeCheck();
        this.excludeLabels.clear();
        this.excludeLabels.addAll(excludeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<Category> getCategories() {
        return this.freezeWrap(this.categories);
    }

    public void setCategories(Set<Category> categories) {
        this.freezeCheck();
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<Replacer> getReplacers() {
        return this.freezeWrap(this.replacers);
    }

    public void setReplacers(List<Replacer> replacers) {
        this.freezeCheck();
        this.replacers.clear();
        this.replacers.addAll(replacers);
    }

    public Set<Labeler> getLabelers() {
        return this.freezeWrap(this.labelers);
    }

    public void setLabelers(Set<Labeler> labelers) {
        this.freezeCheck();
        this.labelers.clear();
        this.labelers.addAll(labelers);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.freezeCheck();
        this.format = format;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.freezeCheck();
        this.content = content;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.freezeCheck();
        this.contentTemplate = contentTemplate;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.freezeCheck();
        this.preset = preset;
    }

    public Hide getHide() {
        return this.hide;
    }

    public void setHide(Hide hide) {
        this.hide.merge(hide);
    }

    public Contributors getContributors() {
        return this.contributors;
    }

    public void setContributors(Contributors contributors) {
        this.contributors.merge(contributors);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("external", this.external);
        map.put("links", this.isLinks());
        map.put("skipMergeCommits", this.isSkipMergeCommits());
        map.put("sort", (Object)this.sort);
        map.put("formatted", (Object)this.formatted);
        map.put("preset", this.preset);
        map.put("format", this.format);
        map.put("content", this.content);
        map.put("contentTemplate", this.contentTemplate);
        map.put("includeLabels", this.includeLabels);
        map.put("excludeLabels", this.excludeLabels);
        map.put("hide", this.hide.asMap(full));
        map.put("contributors", this.contributors.asMap(full));
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Category category : this.categories) {
            m.put("category " + i++, category.asMap(full));
        }
        map.put("categories", m);
        m = new LinkedHashMap();
        i = 0;
        for (Labeler labeler : this.labelers) {
            m.put("labeler " + i++, labeler.asMap(full));
        }
        map.put("labelers", m);
        m = new LinkedHashMap();
        i = 0;
        for (Replacer replacer : this.replacers) {
            m.put("replacer " + i++, replacer.asMap(full));
        }
        map.put("replacers", m);
        return map;
    }

    public static class Hide
    extends AbstractModelObject<Hide>
    implements Domain {
        private final Set<String> categories = new LinkedHashSet<String>();
        private final Set<String> contributors = new LinkedHashSet<String>();
        private Boolean uncategorized;

        @Override
        public void merge(Hide hide) {
            this.freezeCheck();
            this.uncategorized = this.merge(this.uncategorized, hide.uncategorized);
            this.setCategories(this.merge(this.categories, hide.categories));
            this.setContributors(this.merge(this.contributors, hide.contributors));
        }

        public boolean isUncategorized() {
            return this.uncategorized != null && this.uncategorized != false;
        }

        public void setUncategorized(Boolean uncategorized) {
            this.freezeCheck();
            this.uncategorized = uncategorized;
        }

        public Set<String> getCategories() {
            return this.freezeWrap(this.categories);
        }

        public void setCategories(Set<String> categories) {
            this.freezeCheck();
            this.categories.clear();
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategories(Set<String> categories) {
            this.freezeCheck();
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategory(String category) {
            this.freezeCheck();
            if (StringUtils.isNotBlank((String)category)) {
                this.categories.add(category.trim());
            }
        }

        public boolean containsCategory(String category) {
            if (StringUtils.isNotBlank((String)category)) {
                return this.categories.contains(category.trim());
            }
            return false;
        }

        public Set<String> getContributors() {
            return this.freezeWrap(this.contributors);
        }

        public void setContributors(Set<String> contributors) {
            this.freezeCheck();
            this.contributors.clear();
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributors(Set<String> contributors) {
            this.freezeCheck();
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributor(String contributor) {
            this.freezeCheck();
            if (StringUtils.isNotBlank((String)contributor)) {
                this.contributors.add(contributor.trim());
            }
        }

        public boolean containsContributor(String name) {
            if (StringUtils.isNotBlank((String)name)) {
                String n = name.trim();
                for (String contributor : this.contributors) {
                    if (!n.contains(contributor) && !n.matches(StringUtils.toSafeRegexPattern((String)contributor))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("uncategorized", this.uncategorized);
            map.put("categories", this.categories);
            map.put("contributors", this.contributors);
            return map;
        }

        public boolean isSet() {
            return !this.categories.isEmpty() || !this.contributors.isEmpty() || null != this.uncategorized;
        }
    }

    public static class Contributors
    extends AbstractModelObject<Contributors>
    implements Domain {
        private Boolean enabled;
        private String format;

        @Override
        public void merge(Contributors contributor) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, contributor.enabled);
            this.format = this.merge(this.format, contributor.format);
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.freezeCheck();
            this.format = format;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("format", this.format);
            return map;
        }

        public boolean isSet() {
            return StringUtils.isNotBlank((String)this.format) || null != this.enabled;
        }
    }

    public static class Labeler
    extends AbstractModelObject<Labeler>
    implements Domain {
        public static final Comparator<Labeler> ORDER = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private String label;
        private String title;
        private String body;
        private Integer order;

        @Override
        public void merge(Labeler labeler) {
            this.freezeCheck();
            this.label = this.merge(this.label, labeler.label);
            this.title = this.merge(this.title, labeler.title);
            this.body = this.merge(this.body, labeler.body);
            this.order = this.merge(this.order, labeler.order);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.freezeCheck();
            this.label = label;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.freezeCheck();
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.freezeCheck();
            this.body = body;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.freezeCheck();
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Labeler labeler = (Labeler)o;
            return Objects.equals(this.title, labeler.title) && Objects.equals(this.body, labeler.body);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.body);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("label", this.label);
            map.put("title", this.title);
            map.put("body", this.body);
            map.put("order", this.order);
            return map;
        }
    }

    public static class Replacer
    extends AbstractModelObject<Replacer>
    implements Domain {
        private String search;
        private String replace = "";

        @Override
        public void merge(Replacer replacer) {
            this.freezeCheck();
            this.search = this.merge(this.search, replacer.search);
            this.replace = this.merge(this.replace, replacer.replace);
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.freezeCheck();
            this.search = search;
        }

        public String getReplace() {
            return this.replace;
        }

        public void setReplace(String replace) {
            this.freezeCheck();
            this.replace = replace;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("search", this.search);
            map.put("replace", this.replace);
            return map;
        }
    }

    public static class Category
    extends AbstractModelObject<Category>
    implements Domain {
        public static final Comparator<Category> ORDER = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private final Set<String> labels = new LinkedHashSet<String>();
        private String key;
        private String title;
        private String format;
        private Integer order;

        @Override
        public void merge(Category category) {
            this.freezeCheck();
            this.key = this.merge(this.key, category.key);
            this.title = this.merge(this.title, category.title);
            this.format = this.merge(this.format, category.format);
            this.order = this.merge(this.order, category.order);
            this.setLabels(this.merge(this.labels, category.labels));
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.freezeCheck();
            this.format = format;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.freezeCheck();
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.freezeCheck();
            this.title = title;
            if (StringUtils.isBlank((String)this.key)) {
                this.key = title;
            }
        }

        public Set<String> getLabels() {
            return this.freezeWrap(this.labels);
        }

        public void setLabels(Set<String> labels) {
            this.freezeCheck();
            this.labels.clear();
            this.labels.addAll(labels);
        }

        public void addLabels(Set<String> labels) {
            this.freezeCheck();
            this.labels.addAll(labels);
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.freezeCheck();
            this.order = order;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("key", this.key);
            map.put("title", this.title);
            map.put("labels", this.labels);
            map.put("format", this.format);
            map.put("order", this.order);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Category category = (Category)o;
            return this.key.equals(category.key);
        }

        public int hashCode() {
            return Objects.hash(this.title);
        }

        public static Set<Category> sort(Set<Category> categories) {
            TreeSet<Category> tmp = new TreeSet<Category>(ORDER);
            tmp.addAll(categories);
            return tmp;
        }

        public static Category of(String key, String title, String format, String ... labels) {
            Category category = new Category();
            category.key = key;
            category.title = title;
            category.format = format;
            category.labels.addAll(Arrays.asList(labels));
            return category;
        }
    }

    public static enum Sort {
        ASC,
        DESC;

    }
}

