/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.WebUploader;
import org.jreleaser.util.Templates;

abstract class AbstractWebUploader<S extends AbstractWebUploader<S>>
extends AbstractUploader<S>
implements WebUploader {
    protected String uploadUrl;
    protected String downloadUrl;

    protected AbstractWebUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S uploader) {
        this.freezeCheck();
        super.merge(uploader);
        this.uploadUrl = this.merge(this.uploadUrl, ((AbstractWebUploader)uploader).uploadUrl);
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractWebUploader)uploader).downloadUrl);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.uploadUrl, p);
    }

    @Override
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(String uploadUrl) {
        this.freezeCheck();
        this.uploadUrl = uploadUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.freezeCheck();
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("uploadUrl", this.uploadUrl);
        props.put("downloadUrl", this.downloadUrl);
    }
}

