/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jreleaser.model.ModelObject;
import org.jreleaser.util.StringUtils;

public abstract class AbstractModelObject<S extends AbstractModelObject<S>>
implements ModelObject<S> {
    @JsonIgnore
    protected boolean frozen;

    @Override
    public void freeze() {
        this.frozen = true;
    }

    public void mutate(Mutator mutator) {
        if (null == mutator) {
            return;
        }
        boolean isFrozen = this.frozen;
        try {
            this.frozen = false;
            mutator.mutate();
        }
        finally {
            this.frozen = isFrozen;
        }
    }

    protected void freezeCheck() {
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
    }

    protected <T> List<T> freezeWrap(List<T> list) {
        return this.frozen ? Collections.unmodifiableList(list) : list;
    }

    protected <T> Set<T> freezeWrap(Set<T> set) {
        return this.frozen ? Collections.unmodifiableSet(set) : set;
    }

    protected <K, V> Map<K, V> freezeWrap(Map<K, V> map) {
        return this.frozen ? Collections.unmodifiableMap(map) : map;
    }

    protected Properties freezeWrap(Properties props) {
        return this.frozen ? new Properties(props) : props;
    }

    protected String merge(String existing, String incoming) {
        return StringUtils.isNotBlank((String)incoming) ? incoming : existing;
    }

    protected Boolean merge(Boolean existing, Boolean incoming) {
        return null != incoming ? incoming : existing;
    }

    protected Integer merge(Integer existing, Integer incoming) {
        return null != incoming ? incoming : existing;
    }

    protected int merge(int existing, int incoming) {
        return 0 != incoming ? incoming : existing;
    }

    protected <T> T merge(T existing, T incoming) {
        return null != incoming ? incoming : existing;
    }

    protected <T> List<T> merge(List<T> existing, List<T> incoming) {
        ArrayList<T> l1 = new ArrayList<T>();
        if (null != existing) {
            l1.addAll(existing);
        }
        if (null != incoming && !incoming.isEmpty()) {
            ArrayList<T> l2 = new ArrayList<T>(incoming);
            l2.removeAll(l1);
            l1.addAll(l2);
        }
        return l1;
    }

    protected <T> Set<T> merge(Set<T> existing, Set<T> incoming) {
        LinkedHashSet<T> s1 = new LinkedHashSet<T>();
        if (null != existing) {
            s1.addAll(existing);
        }
        if (null != incoming && !incoming.isEmpty()) {
            LinkedHashSet<T> s2 = new LinkedHashSet<T>(incoming);
            s2.removeAll(s1);
            s1.addAll(s2);
        }
        return s1;
    }

    protected <T> Map<String, T> merge(Map<String, T> existing, Map<String, T> incoming) {
        LinkedHashMap<String, T> m1 = new LinkedHashMap<String, T>();
        if (null != existing) {
            m1.putAll(existing);
        }
        if (null != incoming && !incoming.isEmpty()) {
            LinkedHashMap<String, T> m2 = new LinkedHashMap<String, T>(incoming);
            if (null != existing) {
                m2.keySet().removeAll(existing.keySet());
            }
            m1.putAll(m2);
        }
        return m1;
    }

    protected <E extends ModelObject<E>, T extends E> Map<String, T> mergeModel(Map<String, T> existing, Map<String, T> incoming) {
        LinkedHashMap<String, Object> m1 = new LinkedHashMap<String, Object>();
        if (null != existing) {
            m1.putAll(existing);
        }
        if (null != incoming && !incoming.isEmpty()) {
            for (Map.Entry<String, T> e : incoming.entrySet()) {
                String key = e.getKey();
                if (null != existing && existing.containsKey(key)) {
                    ModelObject value = (ModelObject)existing.get(key);
                    value.merge((ModelObject)e.getValue());
                    continue;
                }
                m1.put(key, (ModelObject)e.getValue());
            }
        }
        return m1;
    }

    public static interface Mutator {
        public void mutate() throws RuntimeException;
    }
}

