/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Executable
extends AbstractModelObject<Executable>
implements Domain {
    private static final long serialVersionUID = -2611682172967876842L;
    private String name;
    private String unixExtension;
    private String windowsExtension = "bat";
    @JsonIgnore
    private final org.jreleaser.model.api.common.Executable immutable = new org.jreleaser.model.api.common.Executable(){
        private static final long serialVersionUID = 5589040357178439205L;

        public String getName() {
            return Executable.this.name;
        }

        public String getUnixExtension() {
            return Executable.this.unixExtension;
        }

        public String getWindowsExtension() {
            return Executable.this.windowsExtension;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Executable.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.common.Executable asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Executable source) {
        this.name = this.merge(this.name, source.name);
        this.unixExtension = this.merge(this.unixExtension, source.unixExtension);
        this.windowsExtension = this.merge(this.windowsExtension, source.windowsExtension);
    }

    public String resolveExecutable(String platform) {
        if (PlatformUtils.isWindows((String)platform)) {
            return this.name + this.resolveWindowsExtension();
        }
        return this.name + this.resolveUnixExtension();
    }

    public String resolveUnixExtension() {
        return StringUtils.isNotBlank((String)this.unixExtension) ? "." + this.unixExtension : "";
    }

    public String resolveWindowsExtension() {
        return "." + this.windowsExtension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnixExtension() {
        return this.unixExtension;
    }

    public void setUnixExtension(String unixExtension) {
        this.unixExtension = unixExtension;
    }

    public String getWindowsExtension() {
        return this.windowsExtension;
    }

    public void setWindowsExtension(String windowsExtension) {
        this.windowsExtension = windowsExtension;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("unixExtension", this.unixExtension);
        map.put("windowsExtension", this.windowsExtension);
        return map;
    }
}

