/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.NativeImageAssembler;
import org.jreleaser.model.api.catalog.swid.SwidTag;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.common.Matrix;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractJavaAssembler;
import org.jreleaser.model.internal.catalog.swid.SwidTagAware;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.ArchiveOptions;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssembler
extends AbstractJavaAssembler<NativeImageAssembler, org.jreleaser.model.api.assemble.NativeImageAssembler>
implements SwidTagAware {
    private static final long serialVersionUID = -6941740718518870981L;
    private final List<String> args = new ArrayList<String>();
    private final Set<String> components = new LinkedHashSet<String>();
    private final org.jreleaser.model.internal.common.Artifact graal = new org.jreleaser.model.internal.common.Artifact();
    private final Set<org.jreleaser.model.internal.common.Artifact> graalJdks = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final Archiving archiving = new Archiving();
    private final org.jreleaser.model.internal.common.Matrix matrix = new org.jreleaser.model.internal.common.Matrix();
    private final org.jreleaser.model.internal.common.Artifact graalJdkPattern = new org.jreleaser.model.internal.common.Artifact();
    private final Upx upx = new Upx();
    private final LinuxX86 linuxX86 = new LinuxX86();
    private final WindowsX86 windowsX86 = new WindowsX86();
    private final MacosX86 macosX86 = new MacosX86();
    private final LinuxArm linuxArm = new LinuxArm();
    private final MacosArm macosArm = new MacosArm();
    private final ArchiveOptions options = new ArchiveOptions();
    private String imageName;
    private String imageNameTransform;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.NativeImageAssembler immutable = new org.jreleaser.model.api.assemble.NativeImageAssembler(){
        private static final long serialVersionUID = 2532557224813258883L;
        private Set<? extends Artifact> artifacts;
        private Set<? extends Artifact> graalJdks;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;
        private List<? extends org.jreleaser.model.api.common.Glob> jars;
        private List<? extends org.jreleaser.model.api.common.Glob> files;

        public String getImageName() {
            return NativeImageAssembler.this.imageName;
        }

        public String getImageNameTransform() {
            return NativeImageAssembler.this.imageNameTransform;
        }

        @Deprecated
        public Archive.Format getArchiveFormat() {
            return NativeImageAssembler.this.getArchiveFormat();
        }

        public NativeImageAssembler.Archiving getArchiving() {
            return NativeImageAssembler.this.archiving.asImmutable();
        }

        public org.jreleaser.model.api.common.ArchiveOptions getOptions() {
            return NativeImageAssembler.this.options.asImmutable();
        }

        public Artifact getGraal() {
            return NativeImageAssembler.this.graal.asImmutable();
        }

        public Set<? extends Artifact> getGraalJdks() {
            if (null == this.graalJdks) {
                this.graalJdks = NativeImageAssembler.this.graalJdks.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.graalJdks;
        }

        public boolean isApplyDefaultMatrix() {
            return NativeImageAssembler.this.isApplyDefaultMatrix();
        }

        public Matrix getMatrix() {
            return NativeImageAssembler.this.matrix.asImmutable();
        }

        public Artifact getGraalJdkPattern() {
            return NativeImageAssembler.this.graalJdkPattern.asImmutable();
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(NativeImageAssembler.this.args);
        }

        public Set<String> getComponents() {
            return Collections.unmodifiableSet(NativeImageAssembler.this.components);
        }

        public NativeImageAssembler.Upx getUpx() {
            return NativeImageAssembler.this.upx.asImmutable();
        }

        public NativeImageAssembler.Linux getLinux() {
            return this.getLinuxX86();
        }

        public NativeImageAssembler.Windows getWindows() {
            return this.getWindowsX86();
        }

        public NativeImageAssembler.Osx getOsx() {
            return this.getMacosX86();
        }

        public NativeImageAssembler.LinuxX86 getLinuxX86() {
            return NativeImageAssembler.this.linuxX86.asImmutable();
        }

        public NativeImageAssembler.WindowsX86 getWindowsX86() {
            return NativeImageAssembler.this.windowsX86.asImmutable();
        }

        public NativeImageAssembler.MacosX86 getMacosX86() {
            return NativeImageAssembler.this.macosX86.asImmutable();
        }

        public NativeImageAssembler.LinuxArm getLinuxArm() {
            return NativeImageAssembler.this.linuxArm.asImmutable();
        }

        public NativeImageAssembler.MacosArm getMacosArm() {
            return NativeImageAssembler.this.macosArm.asImmutable();
        }

        public String getExecutable() {
            return NativeImageAssembler.this.getExecutable();
        }

        public String getTemplateDirectory() {
            return NativeImageAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(NativeImageAssembler.this.getSkipTemplates());
        }

        public Java getJava() {
            return NativeImageAssembler.this.getJava().asImmutable();
        }

        public Artifact getMainJar() {
            return NativeImageAssembler.this.getMainJar().asImmutable();
        }

        public List<? extends org.jreleaser.model.api.common.Glob> getJars() {
            if (null == this.jars) {
                this.jars = NativeImageAssembler.this.getJars().stream().map(Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = NativeImageAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends org.jreleaser.model.api.common.Glob> getFiles() {
            if (null == this.files) {
                this.files = NativeImageAssembler.this.getFiles().stream().map(Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Platform getPlatform() {
            return NativeImageAssembler.this.getPlatform().asImmutable();
        }

        public SwidTag getSwid() {
            return NativeImageAssembler.this.getSwid().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return NativeImageAssembler.this.getDistributionType();
        }

        public String getType() {
            return NativeImageAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return NativeImageAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return NativeImageAssembler.this.isExported();
        }

        public String getName() {
            return NativeImageAssembler.this.getName();
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = NativeImageAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = NativeImageAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return NativeImageAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return NativeImageAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(NativeImageAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return NativeImageAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(NativeImageAssembler.this.getExtraProperties());
        }
    };

    public NativeImageAssembler() {
        super("native-image");
    }

    @Override
    public org.jreleaser.model.api.assemble.NativeImageAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.BINARY;
    }

    @Override
    public void merge(NativeImageAssembler source) {
        super.merge(source);
        this.imageName = this.merge(this.imageName, source.imageName);
        this.imageNameTransform = this.merge(this.imageNameTransform, source.imageNameTransform);
        this.applyDefaultMatrix = this.merge(this.applyDefaultMatrix, source.applyDefaultMatrix);
        this.setArchiving(source.archiving);
        this.setOptions(source.options);
        this.setGraal(source.graal);
        this.setGraalJdks(this.merge(this.graalJdks, source.graalJdks));
        this.setArgs(this.merge(this.args, source.args));
        this.setComponents(this.merge(this.components, source.components));
        this.setUpx(source.upx);
        this.setLinuxX86(source.linuxX86);
        this.setWindowsX86(source.windowsX86);
        this.setMacosX86(source.macosX86);
        this.setLinuxArm(source.linuxArm);
        this.setMacosArm(source.macosArm);
        this.setMatrix(source.matrix);
        this.setGraalJdkPattern(source.graalJdkPattern);
    }

    public String getResolvedImageName(JReleaserContext context) {
        TemplateContext props = context.getModel().props();
        props.setAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, (TemplateContext)props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        TemplateContext props = context.getModel().props();
        props.setAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, (TemplateContext)props);
    }

    public PlatformCustomizer getResolvedPlatformCustomizer() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return PlatformUtils.isArm((String)currentPlatform) ? this.getMacosArm() : this.getMacosX86();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindowsX86();
        }
        return PlatformUtils.isArm((String)currentPlatform) ? this.getLinuxArm() : this.getLinuxX86();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    @Deprecated
    public Archive.Format getArchiveFormat() {
        return this.archiving.getFormat();
    }

    @Deprecated
    public void setArchiveFormat(Archive.Format archiveFormat) {
        JReleaserOutput.nag((String)"nativeImage.archiveFormat is deprecated since 1.18.0 and will be removed in 2.0.0. Use nativeImage.archiving.format instead");
        this.archiving.setFormat(archiveFormat);
    }

    @Deprecated
    public void setArchiveFormat(String archiveFormat) {
        JReleaserOutput.nag((String)"nativeImage.archiveFormat is deprecated since 1.18.0 and will be removed in 2.0.0. Use nativeImage.archiving.format instead");
        this.setArchiveFormat(Archive.Format.of((String)archiveFormat));
    }

    public Archiving getArchiving() {
        return this.archiving;
    }

    public void setArchiving(Archiving archiving) {
        this.archiving.merge(archiving);
    }

    public ArchiveOptions getOptions() {
        return this.options;
    }

    public void setOptions(ArchiveOptions options) {
        this.options.merge(options);
    }

    public org.jreleaser.model.internal.common.Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(org.jreleaser.model.internal.common.Artifact graal) {
        this.graal.merge(graal);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getGraalJdks() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.graalJdks);
    }

    public void setGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.clear();
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdk(org.jreleaser.model.internal.common.Artifact jdk) {
        if (null != jdk) {
            this.graalJdks.add(jdk);
        }
    }

    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    public org.jreleaser.model.internal.common.Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(org.jreleaser.model.internal.common.Matrix matrix) {
        this.matrix.merge(matrix);
    }

    public org.jreleaser.model.internal.common.Artifact getGraalJdkPattern() {
        return this.graalJdkPattern;
    }

    public void setGraalJdkPattern(org.jreleaser.model.internal.common.Artifact artifactPattern) {
        this.graalJdkPattern.merge(artifactPattern);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public void setComponents(Set<String> components) {
        this.components.clear();
        this.components.addAll(components);
    }

    public Upx getUpx() {
        return this.upx;
    }

    public void setUpx(Upx upx) {
        this.upx.merge(upx);
    }

    @Deprecated
    public LinuxX86 getLinux() {
        return this.getLinuxX86();
    }

    @Deprecated
    public void setLinux(LinuxX86 linux) {
        JReleaserOutput.nag((String)"native-image.linux is deprecated since 1.17.0 and will be removed in 2.0.0. Use native-image.linuxX86 instead");
        this.setLinuxX86(linux);
    }

    @Deprecated
    public WindowsX86 getWindows() {
        return this.getWindowsX86();
    }

    @Deprecated
    public void setWindows(WindowsX86 windows) {
        JReleaserOutput.nag((String)"native-image.windows is deprecated since 1.17.0 and will be removed in 2.0.0. Use native-image.windowsX86 instead");
        this.setWindowsX86(windows);
    }

    @Deprecated
    public MacosX86 getOsx() {
        return this.getMacosX86();
    }

    @Deprecated
    public void setOsx(MacosX86 osx) {
        JReleaserOutput.nag((String)"native-image.osx is deprecated since 1.17.0 and will be removed in 2.0.0. Use native-image.macosX86 instead");
        this.setMacosX86(osx);
    }

    public LinuxX86 getLinuxX86() {
        return this.linuxX86;
    }

    public void setLinuxX86(LinuxX86 linuxX86) {
        this.linuxX86.merge(linuxX86);
    }

    public WindowsX86 getWindowsX86() {
        return this.windowsX86;
    }

    public void setWindowsX86(WindowsX86 windowsX86) {
        this.windowsX86.merge(windowsX86);
    }

    public MacosX86 getMacosX86() {
        return this.macosX86;
    }

    public void setMacosX86(MacosX86 macosX86) {
        this.macosX86.merge(macosX86);
    }

    public LinuxArm getLinuxArm() {
        return this.linuxArm;
    }

    public void setLinuxArm(LinuxArm linuxArm) {
        this.linuxArm.merge(linuxArm);
    }

    public MacosArm getMacosArm() {
        return this.macosArm;
    }

    public void setMacosArm(MacosArm macosArm) {
        this.macosArm.merge(macosArm);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiving", this.archiving.asMap(full));
        props.put("options", this.options.asMap(full));
        props.put("applyDefaultMatrix", this.isApplyDefaultMatrix());
        this.matrix.asMap(props);
        props.put("graalJdkPattern", this.graalJdkPattern.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact graalJdk : this.getGraalJdks()) {
            mappedJdks.put("jdk " + i++, graalJdk.asMap(full));
        }
        props.put("graal", this.graal.asMap(full));
        props.put("graalJdks", mappedJdks);
        props.put("args", this.args);
        props.put("components", this.components);
        props.put("upx", this.upx.asMap(full));
        if (full || this.linuxX86.isSet()) {
            props.putAll(this.linuxX86.asMap(full));
        }
        if (full || this.macosX86.isSet()) {
            props.putAll(this.macosX86.asMap(full));
        }
        if (full || this.windowsX86.isSet()) {
            props.putAll(this.windowsX86.asMap(full));
        }
        if (full || this.linuxArm.isSet()) {
            props.putAll(this.linuxArm.asMap(full));
        }
        if (full || this.macosArm.isSet()) {
            props.putAll(this.macosArm.asMap(full));
        }
    }

    public static final class MacosArm
    extends AbstractPlatformCustomizer<MacosArm> {
        private static final long serialVersionUID = 4870042060382221246L;
        @JsonIgnore
        private final NativeImageAssembler.MacosArm immutable = new NativeImageAssembler.MacosArm(){
            private static final long serialVersionUID = -432154406205528371L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public MacosArm() {
            super("macosArm");
        }

        public NativeImageAssembler.MacosArm asImmutable() {
            return this.immutable;
        }
    }

    public static final class LinuxArm
    extends AbstractPlatformCustomizer<LinuxArm> {
        private static final long serialVersionUID = 7581399244465819003L;
        @JsonIgnore
        private final NativeImageAssembler.LinuxArm immutable = new NativeImageAssembler.LinuxArm(){
            private static final long serialVersionUID = -6003576591744585492L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public LinuxArm() {
            super("linuxArm");
        }

        public NativeImageAssembler.LinuxArm asImmutable() {
            return this.immutable;
        }
    }

    public static final class MacosX86
    extends AbstractPlatformCustomizer<MacosX86> {
        private static final long serialVersionUID = 1765626220071702695L;
        @JsonIgnore
        private final NativeImageAssembler.MacosX86 immutable = new NativeImageAssembler.MacosX86(){
            private static final long serialVersionUID = 5024962242878918936L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public MacosX86() {
            super("macosX86");
        }

        public NativeImageAssembler.MacosX86 asImmutable() {
            return this.immutable;
        }
    }

    public static final class WindowsX86
    extends AbstractPlatformCustomizer<WindowsX86> {
        private static final long serialVersionUID = -2428122936085887109L;
        @JsonIgnore
        private final NativeImageAssembler.WindowsX86 immutable = new NativeImageAssembler.WindowsX86(){
            private static final long serialVersionUID = 5225971842238088904L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WindowsX86() {
            super("windowsX86");
        }

        public NativeImageAssembler.WindowsX86 asImmutable() {
            return this.immutable;
        }
    }

    public static final class LinuxX86
    extends AbstractPlatformCustomizer<LinuxX86> {
        private static final long serialVersionUID = -8831893038081740645L;
        @JsonIgnore
        private final NativeImageAssembler.LinuxX86 immutable = new NativeImageAssembler.LinuxX86(){
            private static final long serialVersionUID = -3352619976211811469L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public LinuxX86() {
            super("linuxX86");
        }

        public NativeImageAssembler.LinuxX86 asImmutable() {
            return this.immutable;
        }
    }

    public static final class Upx
    extends AbstractActivatable<Upx>
    implements Domain {
        private static final long serialVersionUID = -4962541080085819348L;
        private final List<String> args = new ArrayList<String>();
        private String version;
        @JsonIgnore
        private final NativeImageAssembler.Upx immutable = new NativeImageAssembler.Upx(){
            private static final long serialVersionUID = 3190807504460186043L;

            public String getVersion() {
                return version;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public NativeImageAssembler.Upx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Upx source) {
            super.merge(source);
            this.version = this.merge(this.version, source.version);
            this.setArgs(this.merge(this.args, source.args));
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("active", this.getActive());
            props.put("version", this.version);
            return props;
        }
    }

    public static final class Archiving
    extends AbstractActivatable<Archiving>
    implements Domain {
        private static final long serialVersionUID = -6730452833078647208L;
        private Boolean enabled;
        private Archive.Format format;
        @JsonIgnore
        private final NativeImageAssembler.Archiving immutable = new NativeImageAssembler.Archiving(){
            private static final long serialVersionUID = -7026942817421830530L;

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Archive.Format getFormat() {
                return format;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public NativeImageAssembler.Archiving asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Archiving source) {
            super.merge(source);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.format = this.merge(this.format, source.format);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public Archive.Format getFormat() {
            return this.format;
        }

        public void setFormat(Archive.Format format) {
            this.format = format;
        }

        public void setFormat(String format) {
            this.format = Archive.Format.of((String)format);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("format", this.format);
            return props;
        }
    }

    private static abstract class AbstractPlatformCustomizer<S extends AbstractPlatformCustomizer<S>>
    extends AbstractModelObject<S>
    implements PlatformCustomizer {
        private static final long serialVersionUID = -6257221685457294205L;
        private final List<String> args = new ArrayList<String>();
        private final String platform;

        protected AbstractPlatformCustomizer(String platform) {
            this.platform = platform;
        }

        @Override
        public void merge(S source) {
            this.setArgs(this.merge(this.args, ((AbstractPlatformCustomizer)source).getArgs()));
        }

        @Override
        public List<String> getArgs() {
            return this.args;
        }

        @Override
        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        public boolean isSet() {
            return !this.args.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>();
            props.put("args", this.args);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }
    }

    public static interface PlatformCustomizer
    extends Domain {
        public String getPlatform();

        public List<String> getArgs();

        public void setArgs(List<String> var1);
    }
}

