/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.Token;

public class Anchors
extends TokenRule {
    private static final String ANCHORS_KEY = "anchors";
    public static final String OPTION_FORBID_UNDECLARED_ALIASES = "forbid-undeclared-aliases";
    public static final String OPTION_FORBID_DUPLICATED_ANCHORS = "forbid-duplicated-anchors";
    public static final String OPTION_FORBID_UNUSED_ANCHORS = "forbid-unused-anchors";

    public Anchors() {
        this.registerOption(OPTION_FORBID_UNDECLARED_ALIASES, true);
        this.registerOption(OPTION_FORBID_DUPLICATED_ANCHORS, false);
        this.registerOption(OPTION_FORBID_UNUSED_ANCHORS, false);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if ((Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNDECLARED_ALIASES)) || Boolean.TRUE.equals(conf.get(OPTION_FORBID_DUPLICATED_ANCHORS)) || Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNUSED_ANCHORS))) && (token instanceof StreamStartToken || token instanceof DocumentStartToken || token instanceof DocumentEndToken)) {
            context.put(ANCHORS_KEY, new HashMap());
        }
        if (Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNDECLARED_ALIASES)) && token instanceof AliasToken && !this.getContextMap(context).containsKey(((AliasToken)token).getValue())) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("found undeclared alias \"%s\"", ((AliasToken)token).getValue())));
        }
        if (Boolean.TRUE.equals(conf.get(OPTION_FORBID_DUPLICATED_ANCHORS)) && token instanceof AnchorToken && this.getContextMap(context).containsKey(((AnchorToken)token).getValue())) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("found duplicated anchor \"%s\"", ((AnchorToken)token).getValue())));
        }
        if (Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNUSED_ANCHORS))) {
            if (next instanceof StreamEndToken || next instanceof DocumentStartToken || next instanceof DocumentEndToken) {
                for (String k : this.getContextMap(context).keySet()) {
                    Map info = (Map)this.getContextMap(context).get(k);
                    if (!Boolean.FALSE.equals(info.get("used"))) continue;
                    problems.add(new LintProblem((Integer)info.get("line") + 1, (Integer)info.get("column") + 1, String.format("found unused anchor \"%s\"", k)));
                }
            } else if (token instanceof AliasToken) {
                this.getContextMap(context).getOrDefault(((AliasToken)token).getValue(), new HashMap()).put("used", true);
            }
        }
        if ((Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNDECLARED_ALIASES)) || Boolean.TRUE.equals(conf.get(OPTION_FORBID_DUPLICATED_ANCHORS)) || Boolean.TRUE.equals(conf.get(OPTION_FORBID_UNUSED_ANCHORS))) && token instanceof AnchorToken) {
            this.getContextMap(context).put(((AnchorToken)token).getValue(), Stream.of(new AbstractMap.SimpleEntry<String, Integer>("line", token.getStartMark().getLine()), new AbstractMap.SimpleEntry<String, Integer>("column", token.getStartMark().getColumn()), new AbstractMap.SimpleEntry<String, Boolean>("used", false)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return problems;
    }

    private Map<String, Object> getContextMap(Map<String, Object> context) {
        return (Map)context.get(ANCHORS_KEY);
    }
}

