/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.hooks;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.hooks.ScriptHook;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.hooks.Hook;
import org.jreleaser.model.internal.hooks.Hooks;
import org.jreleaser.model.internal.hooks.ScriptHook;
import org.jreleaser.model.internal.hooks.ScriptHooks;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class HookExecutor {
    private static final String JRELEASER_OUTPUT = "JRELEASER_OUTPUT:";
    private final JReleaserContext context;

    public HookExecutor(JReleaserContext context) {
        this.context = context;
    }

    public void execute(String step, Runnable runnable) {
        this.executeHooks(ExecutionEvent.before((String)step));
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            this.executeHooks(ExecutionEvent.failure((String)step, (Throwable)e));
            throw e;
        }
        this.executeHooks(ExecutionEvent.success((String)step));
    }

    public void executeHooks(ExecutionEvent event) {
        Hooks hooks = this.context.getModel().getHooks();
        if (!hooks.isEnabled() || this.evaluateCondition(hooks.getCondition())) {
            return;
        }
        Map<String, String> rootEnv = this.resolveEnvironment(hooks.getEnvironment());
        this.executeScriptHooks(event, rootEnv);
        this.executeCommandHooks(event, rootEnv);
    }

    private boolean evaluateCondition(String condition) {
        return StringUtils.isNotBlank((String)condition) && StringUtils.isFalse((Object)this.context.eval(condition));
    }

    private Map<String, String> resolveEnvironment(Map<String, String> src) {
        return this.resolveEnvironment(src, null);
    }

    private Map<String, String> resolveEnvironment(Map<String, String> src, TemplateContext additionalContext) {
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        TemplateContext props = this.context.props().setAll(additionalContext);
        src.forEach((k, v) -> {
            String value = Templates.resolveTemplate((String)v, (TemplateContext)props);
            if (StringUtils.isNotBlank((String)value)) {
                env.put((String)k, value);
            }
        });
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptHooks(ExecutionEvent event, Map<String, String> rootEnv) {
        ScriptHooks scriptHooks = this.context.getModel().getHooks().getScript();
        if (!scriptHooks.isEnabled() || this.evaluateCondition(scriptHooks.getCondition())) {
            return;
        }
        ArrayList<Object> hooks = new ArrayList<Object>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(scriptHooks.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(scriptHooks.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(scriptHooks.getFailure(), event));
            }
        }
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.script.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (ScriptHook scriptHook : hooks) {
                if (!scriptHook.getMatrix().isEmpty()) {
                    for (Map matrixRow : scriptHook.getMatrix().resolve()) {
                        Map<String, String> localEnv = new LinkedHashMap<String, String>(rootEnv);
                        localEnv.putAll(scriptHooks.getEnvironment());
                        localEnv = this.resolveEnvironment(localEnv, this.asTemplateContext(matrixRow));
                        Path scriptFile = null;
                        try {
                            scriptFile = this.createScriptFile(this.context, scriptHook, this.asTemplateContext(matrixRow), event);
                        }
                        catch (IOException e) {
                            throw new JReleaserException(RB.$((String)"ERROR_script_hook_create_error", (Object[])new Object[0]), (Throwable)e);
                        }
                        String resolvedCmd = scriptHook.getShell().expression().replace("{{script}}", scriptFile.toAbsolutePath().toString());
                        this.executeCommandLine(localEnv, this.asTemplateContext(matrixRow), (Hook)scriptHook, resolvedCmd, resolvedCmd, "ERROR_script_hook_unexpected_error");
                    }
                    continue;
                }
                Map<String, String> localEnv = new LinkedHashMap<String, String>(rootEnv);
                localEnv.putAll(scriptHooks.getEnvironment());
                localEnv = this.resolveEnvironment(localEnv);
                Path scriptFile = null;
                try {
                    scriptFile = this.createScriptFile(this.context, scriptHook, null, event);
                }
                catch (IOException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_script_hook_create_error", (Object[])new Object[0]), (Throwable)e);
                }
                String resolvedCmd = scriptHook.getShell().expression().replace("{{script}}", scriptFile.toAbsolutePath().toString());
                this.executeCommandLine(localEnv, null, (Hook)scriptHook, resolvedCmd, resolvedCmd, "ERROR_script_hook_unexpected_error");
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
    }

    private Path createScriptFile(JReleaserContext context, ScriptHook hook, TemplateContext additionalContext, ExecutionEvent event) throws IOException {
        String scriptContents = hook.getResolvedRun(context, additionalContext, event);
        Path scriptFile = Files.createTempFile("jreleaser", hook.getShell().extension(), new FileAttribute[0]);
        if (hook.getShell() == ScriptHook.Shell.PWSH || hook.getShell() == ScriptHook.Shell.POWERSHELL) {
            scriptContents = "$ErrorActionPreference = 'stop'" + System.lineSeparator() + scriptContents;
            scriptContents = scriptContents + System.lineSeparator() + "if ((Test-Path -LiteralPath variable:\\LASTEXITCODE)) { exit $LASTEXITCODE }";
        }
        Files.write(scriptFile, scriptContents.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
        return scriptFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommandHooks(ExecutionEvent event, Map<String, String> rootEnv) {
        CommandHooks commandHooks = this.context.getModel().getHooks().getCommand();
        if (!commandHooks.isEnabled() || this.evaluateCondition(commandHooks.getCondition())) {
            return;
        }
        ArrayList<Object> hooks = new ArrayList<Object>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(commandHooks.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(commandHooks.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(commandHooks.getFailure(), event));
            }
        }
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.command.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (CommandHook commandHook : hooks) {
                if (!commandHook.getMatrix().isEmpty()) {
                    for (Map matrixRow : commandHook.getMatrix().resolve()) {
                        Map<String, String> localEnv = new LinkedHashMap<String, String>(rootEnv);
                        localEnv.putAll(commandHooks.getEnvironment());
                        localEnv = this.resolveEnvironment(localEnv, this.asTemplateContext(matrixRow));
                        String resolvedCmd = commandHook.getResolvedCmd(this.context, this.asTemplateContext(matrixRow), event);
                        this.executeCommandLine(localEnv, this.asTemplateContext(matrixRow), (Hook)commandHook, commandHook.getCmd(), resolvedCmd, "ERROR_command_hook_unexpected_error");
                    }
                    continue;
                }
                Map<String, String> localEnv = new LinkedHashMap<String, String>(rootEnv);
                localEnv.putAll(commandHooks.getEnvironment());
                localEnv = this.resolveEnvironment(localEnv);
                String resolvedCmd = commandHook.getResolvedCmd(this.context, null, event);
                this.executeCommandLine(localEnv, null, (Hook)commandHook, commandHook.getCmd(), resolvedCmd, "ERROR_command_hook_unexpected_error");
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
    }

    private void executeCommandLine(Map<String, String> localEnv, TemplateContext additionalContext, Hook hook, String cmd, String resolvedCmd, String errorKey) {
        List<String> commandLine = null;
        Map<String, String> hookEnv = new LinkedHashMap<String, String>(localEnv);
        hookEnv.putAll(hook.getEnvironment());
        hookEnv = this.resolveEnvironment(hookEnv, additionalContext);
        try {
            commandLine = HookExecutor.parseCommand(resolvedCmd);
        }
        catch (IllegalStateException e) {
            throw new JReleaserException(RB.$((String)"ERROR_command_hook_parser_error", (Object[])new Object[]{cmd}), (Throwable)e);
        }
        try {
            Command command = new Command(commandLine);
            this.processOutput(this.executeCommand(this.context.getBasedir(), command, hookEnv, hook.isVerbose()));
        }
        catch (CommandException e) {
            if (!hook.isContinueOnError()) {
                throw new JReleaserException(RB.$((String)errorKey, (Object[])new Object[0]), (Throwable)e);
            }
            if (null != e.getCause()) {
                this.context.getLogger().warn(e.getCause().getMessage());
            } else {
                this.context.getLogger().warn(e.getMessage());
            }
            this.context.getLogger().trace(RB.$((String)errorKey, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void processOutput(Command.Result result) {
        if (!result.getOut().contains(JRELEASER_OUTPUT)) {
            return;
        }
        for (String line : result.getOut().split(System.lineSeparator())) {
            if (!line.startsWith(JRELEASER_OUTPUT)) continue;
            line = line.substring(JRELEASER_OUTPUT.length());
            int p = line.indexOf("=");
            String key = line.substring(0, p);
            String value = line.substring(p + 1);
            this.context.getModel().getEnvironment().getProperties().put(key, value);
        }
    }

    private Collection<? extends Hook> filter(List<? extends Hook> hooks, ExecutionEvent event) {
        ArrayList<Hook> tmp = new ArrayList<Hook>();
        for (Hook hook : hooks) {
            if (!hook.isEnabled() || this.evaluateCondition(hook.getCondition())) continue;
            if (!hook.getFilter().getResolvedIncludes().isEmpty()) {
                if (hook.getFilter().getResolvedIncludes().contains(event.getName()) && this.filterByPlatform(hook)) {
                    tmp.add(hook);
                }
            } else if (this.filterByPlatform(hook)) {
                tmp.add(hook);
            }
            if (!hook.getFilter().getResolvedExcludes().contains(event.getName())) continue;
            tmp.remove(hook);
        }
        return tmp;
    }

    private boolean filterByPlatform(Hook hook) {
        if (hook.getPlatforms().isEmpty()) {
            return true;
        }
        boolean success = true;
        for (String platform : hook.getPlatforms()) {
            boolean exclude = false;
            if (platform.startsWith("!")) {
                exclude = true;
                platform = platform.substring(1);
            }
            success &= exclude != PlatformUtils.isCompatible((String)PlatformUtils.getCurrentFull(), (String)platform);
        }
        return success;
    }

    private Command.Result executeCommand(Path directory, Command command, Map<String, String> env, boolean verbose) throws CommandException {
        Command.Result result = new CommandExecutor(this.context.getLogger(), verbose ? CommandExecutor.Output.VERBOSE : CommandExecutor.Output.DEBUG).environment(env).executeCommand(directory, command);
        if (result.getExitValue() != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
        }
        return result;
    }

    public static List<String> parseCommand(String str) {
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(str, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalStateException(RB.$((String)"ERROR_unbalanced_quotes", (Object[])new Object[]{str}));
        }
        return result;
    }

    private TemplateContext asTemplateContext(Map<String, String> matrix) {
        TemplateContext props = new TemplateContext();
        props.setAll(CollectionUtils.mapOf((Object[])new Object[]{"matrix", matrix}));
        return props;
    }
}

